/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.data;

import dev.technici4n.moderndynamics.data.AttachmentUpgradesProvider;
import dev.technici4n.moderndynamics.data.EmptyTestStructureGenerator;
import dev.technici4n.moderndynamics.data.ItemTagsProvider;
import dev.technici4n.moderndynamics.data.LootTablesProvider;
import dev.technici4n.moderndynamics.data.ModelsProvider;
import dev.technici4n.moderndynamics.data.PipeModelsProvider;
import dev.technici4n.moderndynamics.data.RecipesProvider;
import dev.technici4n.moderndynamics.data.SpriteSourceProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="moderndynamics", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture registries = event.getLookupProvider();
        DataGenerator.PackGenerator pack = event.getGenerator().getVanillaPack(true);
        pack.addProvider(packOutput -> new ModelsProvider(packOutput, existingFileHelper));
        pack.addProvider(PipeModelsProvider::new);
        pack.addProvider(packOutput -> new SpriteSourceProvider(packOutput, registries, existingFileHelper));
        pack.addProvider(AttachmentUpgradesProvider::new);
        pack.addProvider(packOutput -> new ItemTagsProvider(packOutput, registries, existingFileHelper));
        pack.addProvider(packOutput -> LootTablesProvider.create(packOutput, registries));
        pack.addProvider(packOutput -> new RecipesProvider(packOutput, registries));
        pack.addProvider(EmptyTestStructureGenerator::new);
    }
}

