/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.compat.rei;

import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeType;
import dev.technici4n.moderndynamics.client.compat.rei.UpgradeDisplay;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public class UpgradeCategory
implements DisplayCategory<UpgradeDisplay> {
    public static final CategoryIdentifier<UpgradeDisplay> ID = CategoryIdentifier.of((ResourceLocation)MdId.of("upgrades"));

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)MdItems.EXTRACTOR);
    }

    public Component getTitle() {
        return Component.translatable((String)"gui.moderndynamics.rei.upgrade_category");
    }

    public CategoryIdentifier<UpgradeDisplay> getCategoryIdentifier() {
        return ID;
    }

    public List<Widget> setupDisplay(UpgradeDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        UpgradeType type = display.upgradeInfo;
        ResourceLocation texture = MdId.of("textures/gui/icons.png");
        int baseY = bounds.y + 5 + 36;
        int countXOffset = 17;
        int countY = bounds.y + 18 + 36;
        int effectWidth = 23;
        int effectSpacing = 5;
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        Point upgradeSlotPoint = new Point(bounds.x + 7, bounds.y + 7);
        widgets.add((Widget)Widgets.createSlot((Point)upgradeSlotPoint).entry(EntryStacks.of((ItemLike)display.item)));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.x + 29, bounds.y + 11), (Component)Component.translatable((String)"gui.moderndynamics.tooltip.upgrades_max", (Object[])new Object[]{type.getSlotLimit()})).leftAligned().noShadow().color(-12566464, -4473925));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.getCenterX(), bounds.y + 5 + 22), (Component)Component.translatable((String)"gui.moderndynamics.tooltip.upgrades_effects").setStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)))).noShadow().color(-12566464, -4473925));
        ArrayList<UpgradeEffect> effects = new ArrayList<UpgradeEffect>();
        effects.add(new UpgradeEffect(0, type.isEnableAdvancedBehavior() ? -1 : 0, "enableAdvancedBehavior", I18n.get((String)"gui.moderndynamics.tooltip.advanced_behavior_available", (Object[])new Object[0])));
        effects.add(new UpgradeEffect(16, type.getAddFilterSlots(), "addFilterSlots", "+" + type.getAddFilterSlots()));
        effects.add(new UpgradeEffect(32, type.getAddItemCount(), "addItemCount", "+" + type.getAddItemCount()));
        effects.add(new UpgradeEffect(48, type.getAddItemSpeed(), "addItemSpeed", "+" + type.getAddItemSpeed() * 100 + "%"));
        effects.add(new UpgradeEffect(64, type.getAddItemTransferFrequency(), "addItemTransferFrequency", "+" + type.getAddItemTransferFrequency() * 100 + "%"));
        effects.add(new UpgradeEffect(80, type.getAddFluidTransfer(), "addFluidTransfer", "+" + type.getAddFluidTransfer() * 100 + "%"));
        effects.add(new UpgradeEffect(96, type.getMultiplyFluidTransfer(), "multiplyFluidTransfer", "+" + type.getMultiplyFluidTransfer() * 100 + "%"));
        effects.removeIf(e -> e.count() == 0);
        if (effects.size() > 0) {
            int totalWidth = effects.size() * effectWidth + (effects.size() - 1) * effectSpacing;
            int baseX = bounds.x + (bounds.getWidth() - totalWidth) / 2;
            for (UpgradeEffect e2 : effects) {
                Rectangle tooltipRect = new Rectangle(baseX, baseY, 20, 20);
                Style greenStyle = Style.EMPTY.applyFormat(ChatFormatting.GREEN);
                MutableComponent tooltip = Component.translatable((String)("gui.moderndynamics.tooltip.upgrade_" + e2.upgradeName()), (Object[])new Object[]{Component.literal((String)e2.greenText).setStyle(greenStyle)});
                widgets.add(Widgets.createTexturedWidget((ResourceLocation)texture, (int)baseX, (int)baseY, (float)e2.textureU(), (float)0.0f, (int)16, (int)16));
                String renderedString = e2.count() > 0 ? "" + e2.count() : "";
                widgets.add((Widget)Widgets.createLabel((Point)new Point(baseX + countXOffset, countY), (Component)Component.literal((String)renderedString)).noShadow().color(-12566464, -4473925));
                widgets.add(Widgets.createDrawableWidget((guiGraphics, mouseX, mouseY, delta) -> {
                    if (tooltipRect.contains(mouseX, mouseY)) {
                        Tooltip.create((Component[])new Component[]{tooltip}).queue();
                    }
                }));
                baseX += effectWidth + effectSpacing;
            }
        }
        return widgets;
    }

    public int getDisplayHeight() {
        return 67;
    }

    private record UpgradeEffect(int textureU, int count, String upgradeName, String greenText) {
    }
}

