/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.compat.jei;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.upgrade.LoadedUpgrades;
import dev.technici4n.moderndynamics.client.compat.jei.GhostIngredientHandler;
import dev.technici4n.moderndynamics.client.compat.jei.UpgradeCategory;
import dev.technici4n.moderndynamics.client.compat.jei.UpgradeDisplay;
import dev.technici4n.moderndynamics.client.screen.AttachedIoScreen;
import dev.technici4n.moderndynamics.gui.menu.FluidConfigSlot;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.util.FluidVariant;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class MdJeiPlugin
implements IModPlugin {
    private IPlatformFluidHelper<?> platformFluidHelper;

    public ResourceLocation getPluginUid() {
        return MdId.of("jei");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.platformFluidHelper = jeiRuntime.getJeiHelpers().getPlatformFluidHelper();
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new UpgradeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (AttachmentItem workstation : List.of(MdItems.ATTRACTOR, MdItems.EXTRACTOR, MdItems.FILTER)) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)workstation), new RecipeType[]{UpgradeCategory.TYPE});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(UpgradeCategory.TYPE, LoadedUpgrades.get().list.stream().map(u -> new UpgradeDisplay((Item)u, LoadedUpgrades.getType(u))).toList());
    }

    public void registerGuiHandlers(final IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AttachedIoScreen.class, new IGuiContainerHandler<AttachedIoScreen<?>>(){

            public List<Rect2i> getGuiExtraAreas(AttachedIoScreen<?> screen) {
                ArrayList<Rect2i> rectangles = new ArrayList<Rect2i>();
                screen.appendExclusionZones(r -> rectangles.add(new Rect2i(r.getX(), r.getY(), r.getWidth(), r.getHeight())));
                return rectangles;
            }

            public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(AttachedIoScreen<?> screen, double mouseX, double mouseY) {
                FluidConfigSlot fluidConfig;
                FluidVariant variant;
                Slot slot = screen.getHoveredSlot();
                if (slot instanceof FluidConfigSlot && !(variant = (fluidConfig = (FluidConfigSlot)slot).getFilter()).isBlank()) {
                    IIngredientManager ing = registration.getJeiHelpers().getIngredientManager();
                    return ing.createTypedIngredient((Object)variant.toStack(1)).map(1.slotArea(screen, fluidConfig));
                }
                return Optional.empty();
            }

            private static <T> Function<ITypedIngredient<T>, IClickableIngredient<T>> slotArea(AttachedIoScreen<?> screen, Slot slot) {
                Rect2i area = new Rect2i(screen.getLeftPos() + slot.x, screen.getTopPos() + slot.y, 16, 16);
                return ing -> new IClickableIngredient<T>((ITypedIngredient)ing, area){
                    final /* synthetic */ ITypedIngredient val$ing;
                    final /* synthetic */ Rect2i val$area;
                    {
                        this.val$ing = iTypedIngredient;
                        this.val$area = rect2i;
                    }

                    public ITypedIngredient<T> getTypedIngredient() {
                        return this.val$ing;
                    }

                    public Rect2i getArea() {
                        return this.val$area;
                    }
                };
            }
        });
        registration.addGhostIngredientHandler(AttachedIoScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
    }
}

