/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment.attached;

import com.google.common.base.Preconditions;
import dev.technici4n.moderndynamics.attachment.IoAttachmentItem;
import dev.technici4n.moderndynamics.attachment.attached.AttachedIo;
import dev.technici4n.moderndynamics.attachment.attached.ItemCachedFilter;
import dev.technici4n.moderndynamics.attachment.settings.FilterDamageMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterModMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterNbtMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterSimilarMode;
import dev.technici4n.moderndynamics.attachment.settings.OversendingMode;
import dev.technici4n.moderndynamics.attachment.settings.RoutingMode;
import dev.technici4n.moderndynamics.gui.menu.AttachmentMenuType;
import dev.technici4n.moderndynamics.gui.menu.ItemAttachedIoMenu;
import dev.technici4n.moderndynamics.model.AttachmentModelData;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.DropHelper;
import dev.technici4n.moderndynamics.util.ExtendedMenuProvider;
import dev.technici4n.moderndynamics.util.ItemVariant;
import dev.technici4n.moderndynamics.util.TransferUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ItemAttachedIo
extends AttachedIo {
    private final Map<ItemVariant, Integer> stuffedItems = new LinkedHashMap<ItemVariant, Integer>();
    private int roundRobinIndex;
    private final NonNullList<ItemVariant> filters = NonNullList.withSize((int)15, (Object)ItemVariant.blank());
    private FilterDamageMode filterDamage;
    private FilterNbtMode filterNbt;
    private FilterModMode filterMod;
    private FilterSimilarMode filterSimilar;
    private RoutingMode routingMode;
    private OversendingMode oversendingMode;
    private int maxItemsInInventory;
    private int maxItemsExtracted;
    boolean maxItemsExtractedAtMax;
    @Nullable
    private ItemCachedFilter cachedFilter;

    public ItemAttachedIo(IoAttachmentItem item, CompoundTag configData, Runnable setChangedCallback, HolderLookup.Provider registries) {
        super(item, configData, setChangedCallback, registries);
        ListTag filterTags = configData.getList("filters", 10);
        for (int i = 0; i < this.filters.size(); ++i) {
            CompoundTag filterTag = filterTags.getCompound(i);
            if (filterTag.isEmpty()) continue;
            this.filters.set(i, (Object)ItemVariant.fromNbt(filterTag, registries));
        }
        this.filterDamage = (FilterDamageMode)ItemAttachedIo.readEnum((Enum[])FilterDamageMode.values(), (CompoundTag)configData, (String)"filterDamage", (Enum)FilterDamageMode.RESPECT_DAMAGE);
        this.filterNbt = (FilterNbtMode)ItemAttachedIo.readEnum((Enum[])FilterNbtMode.values(), (CompoundTag)configData, (String)"filterNbt", (Enum)FilterNbtMode.RESPECT_NBT);
        this.filterMod = (FilterModMode)ItemAttachedIo.readEnum((Enum[])FilterModMode.values(), (CompoundTag)configData, (String)"filterMod", (Enum)FilterModMode.IGNORE_MOD);
        this.filterSimilar = (FilterSimilarMode)ItemAttachedIo.readEnum((Enum[])FilterSimilarMode.values(), (CompoundTag)configData, (String)"filterSimilar", (Enum)FilterSimilarMode.IGNORE_SIMILAR);
        this.routingMode = (RoutingMode)ItemAttachedIo.readEnum((Enum[])RoutingMode.values(), (CompoundTag)configData, (String)"routingMode", (Enum)RoutingMode.CLOSEST);
        this.oversendingMode = (OversendingMode)ItemAttachedIo.readEnum((Enum[])OversendingMode.values(), (CompoundTag)configData, (String)"oversendingMode", (Enum)OversendingMode.PREVENT_OVERSENDING);
        if (configData.contains("maxItemsExtracted", 3)) {
            this.setMaxItemsExtracted(configData.getInt("maxItemsExtracted"));
        } else {
            this.setMaxItemsExtracted(this.getMaxItemsExtractedMaximum());
        }
        this.maxItemsInInventory = configData.getInt("maxItemsInInventory");
        this.maxItemsInInventory = Mth.clamp((int)this.maxItemsInInventory, (int)0, (int)this.getMaxItemsExtractedMaximum());
        this.stuffedItems.clear();
        ListTag stuffedTag = configData.getList("stuffed", 10);
        for (int i = 0; i < stuffedTag.size(); ++i) {
            CompoundTag compound = stuffedTag.getCompound(i);
            ItemVariant variant = ItemVariant.fromNbt(compound.getCompound("v"), registries);
            int amount = compound.getInt("a");
            if (variant.isBlank() || amount <= 0) continue;
            this.stuffedItems.put(variant, amount);
        }
        this.roundRobinIndex = Math.max(0, configData.getInt("roundRobinIndex"));
    }

    @Override
    public CompoundTag writeConfigTag(CompoundTag configData, HolderLookup.Provider registries) {
        super.writeConfigTag(configData, registries);
        ListTag filterTags = new ListTag();
        for (ItemVariant filter : this.filters) {
            if (filter.isBlank()) {
                filterTags.add((Object)new CompoundTag());
                continue;
            }
            filterTags.add((Object)filter.toNbt(registries));
        }
        configData.put("filters", (Tag)filterTags);
        ItemAttachedIo.writeEnum(this.filterDamage, configData, "filterDamage");
        ItemAttachedIo.writeEnum(this.filterNbt, configData, "filterNbt");
        ItemAttachedIo.writeEnum(this.filterMod, configData, "filterMod");
        ItemAttachedIo.writeEnum(this.filterSimilar, configData, "filterSimilar");
        ItemAttachedIo.writeEnum(this.routingMode, configData, "routingMode");
        ItemAttachedIo.writeEnum(this.oversendingMode, configData, "oversendingMode");
        if (this.maxItemsExtracted < this.getMaxItemsExtractedMaximum()) {
            configData.putInt("maxItemsExtracted", this.maxItemsExtracted);
        } else {
            configData.remove("maxItemsExtracted");
        }
        if (this.maxItemsInInventory > 0) {
            configData.putInt("maxItemsInInventory", this.maxItemsInInventory);
        } else {
            configData.remove("maxItemsInInventory");
        }
        ListTag stuffedTag = new ListTag();
        for (Map.Entry<ItemVariant, Integer> entry : this.stuffedItems.entrySet()) {
            CompoundTag compound = new CompoundTag();
            compound.put("v", entry.getKey().toNbt(registries));
            compound.putInt("a", entry.getValue().intValue());
            stuffedTag.add((Object)compound);
        }
        if (!stuffedTag.isEmpty()) {
            configData.put("stuffed", (Tag)stuffedTag);
        }
        if (this.roundRobinIndex != 0) {
            configData.putInt("roundRobinIndex", this.roundRobinIndex);
        }
        return configData;
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.maxItemsExtractedAtMax) {
            this.setMaxItemsExtracted(this.getMaxItemsExtractedMaximum());
        }
        this.setMaxItemsExtracted(this.getMaxItemsExtracted());
    }

    public boolean matchesItemFilter(ItemVariant variant) {
        return this.getCachedFilter().matchesItem(variant);
    }

    public ItemVariant getFilter(int idx) {
        return (ItemVariant)this.filters.get(idx);
    }

    public void setFilter(int idx, ItemVariant variant) {
        if (!variant.equals(this.filters.get(idx))) {
            this.filters.set(idx, (Object)variant);
            this.setChangedCallback.run();
            this.resetCachedFilter();
        }
    }

    public double getItemSpeedupFactor() {
        return this.upgradeContainer.getItemSpeedupFactor();
    }

    public int getItemOperationTickDelay() {
        return this.upgradeContainer.getItemOperationTickDelay();
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    @Override
    @Nullable
    public ExtendedMenuProvider createMenu(final PipeBlockEntity pipe, final Direction side) {
        return new ExtendedMenuProvider(){

            @Override
            public void writeScreenOpeningData(RegistryFriendlyByteBuf buf) {
                AttachmentMenuType.writeScreenOpeningData(pipe, side, ItemAttachedIo.this, buf);
            }

            public Component getDisplayName() {
                return ItemAttachedIo.this.getDisplayName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int syncId, Inventory pPlayerInventory, Player pPlayer) {
                return new ItemAttachedIoMenu(syncId, pPlayerInventory, pipe, side, ItemAttachedIo.this);
            }
        };
    }

    @Override
    public AttachmentModelData getModelData() {
        if (this.isStuffed()) {
            return AttachmentModelData.from(this.getItem().attachment.getStuffed(), this.getItem());
        }
        return super.getModelData();
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.getDrops());
        for (Map.Entry<ItemVariant, Integer> entry : this.stuffedItems.entrySet()) {
            DropHelper.splitIntoStacks(entry.getKey(), entry.getValue().intValue(), drops::add);
        }
        return drops;
    }

    @Override
    public boolean tryClearContents(PipeBlockEntity pipe) {
        if (this.isStuffed()) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (Map.Entry<ItemVariant, Integer> entry : this.stuffedItems.entrySet()) {
                DropHelper.splitIntoStacks(entry.getKey(), entry.getValue().intValue(), drops::add);
            }
            this.stuffedItems.clear();
            DropHelper.dropStacks(pipe, drops);
            pipe.setChanged();
            pipe.sync();
            return true;
        }
        return super.tryClearContents(pipe);
    }

    public boolean isStuffed() {
        return !this.stuffedItems.isEmpty();
    }

    public Map<ItemVariant, Integer> getStuffedItems() {
        return this.stuffedItems;
    }

    public FilterDamageMode getFilterDamage() {
        return this.filterDamage;
    }

    public void setFilterDamage(FilterDamageMode filterDamage) {
        if (filterDamage != this.filterDamage) {
            this.filterDamage = filterDamage;
            this.resetCachedFilter();
        }
    }

    public FilterNbtMode getFilterNbt() {
        return this.isAdvancedBehaviorAllowed() ? this.filterNbt : FilterNbtMode.RESPECT_NBT;
    }

    public void setFilterNbt(FilterNbtMode filterNbt) {
        if (filterNbt != this.filterNbt) {
            this.filterNbt = filterNbt;
            this.resetCachedFilter();
        }
    }

    public FilterModMode getFilterMod() {
        return this.filterMod;
    }

    public void setFilterMod(FilterModMode filterMod) {
        if (filterMod != this.filterMod) {
            this.filterMod = filterMod;
            this.resetCachedFilter();
        }
    }

    public FilterSimilarMode getFilterSimilar() {
        return this.filterSimilar;
    }

    public void setFilterSimilar(FilterSimilarMode value) {
        if (value != this.filterSimilar) {
            this.filterSimilar = value;
            this.resetCachedFilter();
        }
    }

    public RoutingMode getRoutingMode() {
        return this.isAdvancedBehaviorAllowed() ? this.routingMode : RoutingMode.CLOSEST;
    }

    public void setRoutingMode(RoutingMode mode) {
        this.routingMode = mode;
    }

    public OversendingMode getOversendingMode() {
        return this.isAdvancedBehaviorAllowed() ? this.oversendingMode : OversendingMode.PREVENT_OVERSENDING;
    }

    public void setOversendingMode(OversendingMode mode) {
        this.oversendingMode = mode;
    }

    public int getMaxItemsInInventory() {
        return this.maxItemsInInventory;
    }

    public void setMaxItemsInInventory(int value) {
        this.maxItemsInInventory = Mth.clamp((int)value, (int)0, (int)Integer.MAX_VALUE);
    }

    public int getMaxItemsExtracted() {
        return this.maxItemsExtracted;
    }

    public void setMaxItemsExtracted(int value) {
        this.maxItemsExtracted = Mth.clamp((int)value, (int)1, (int)this.getMaxItemsExtractedMaximum());
        this.maxItemsExtractedAtMax = this.maxItemsExtracted == this.getMaxItemsExtractedMaximum();
    }

    public int getMaxItemsExtractedMaximum() {
        return this.upgradeContainer.getItemsPerOperation();
    }

    private ItemCachedFilter getCachedFilter() {
        if (this.cachedFilter == null) {
            this.cachedFilter = new ItemCachedFilter(this.filters.subList(0, this.getFilterSize()), this.getFilterInversion(), this.filterDamage, this.getFilterNbt(), this.filterMod);
        }
        return this.cachedFilter;
    }

    @Override
    protected void resetCachedFilter() {
        this.cachedFilter = null;
    }

    public int getRoundRobinIndex(int maxValue) {
        Preconditions.checkArgument((maxValue > 0 ? 1 : 0) != 0, (Object)"maxValue > 0");
        this.roundRobinIndex %= maxValue;
        return this.roundRobinIndex;
    }

    public void incrementRoundRobin(int incrementSize) {
        if (this.getRoutingMode() == RoutingMode.ROUND_ROBIN) {
            this.roundRobinIndex += incrementSize;
            this.setChangedCallback.run();
        }
    }

    public int moveStuffedToStorage(IItemHandler targetStorage, int maxAmount) {
        int totalMoved = 0;
        Iterator<Map.Entry<ItemVariant, Integer>> it = this.stuffedItems.entrySet().iterator();
        while (it.hasNext() && totalMoved < maxAmount) {
            Map.Entry<ItemVariant, Integer> entry = it.next();
            int stuffedAmount = entry.getValue();
            int inserted = TransferUtil.insertItemStacked(targetStorage, entry.getKey(), Math.min(stuffedAmount, maxAmount - totalMoved));
            if (inserted <= 0) continue;
            totalMoved += inserted;
            if (inserted < stuffedAmount) {
                entry.setValue(stuffedAmount - inserted);
                continue;
            }
            it.remove();
        }
        return totalMoved;
    }
}

