/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.client;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.apothic_attributes.ALConfig;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.apothic_attributes.client.AttributesGui;
import dev.shadowsoffire.apothic_attributes.client.CuriosClientCompat;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.util.Offset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.CritParticle;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.GatherEffectScreenTooltipsEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class AttributesLibClient {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addAttribComponent(ScreenEvent.Init.Post e) {
        Screen screen;
        if (ALConfig.enableAttributesGui && (screen = e.getScreen()) instanceof InventoryScreen) {
            InventoryScreen scn = (InventoryScreen)screen;
            AttributesGui atrComp = new AttributesGui(scn);
            e.addListener((GuiEventListener)atrComp);
            e.addListener((GuiEventListener)atrComp.toggleBtn);
            e.addListener((GuiEventListener)atrComp.hideUnchangedBtn);
            if (AttributesGui.wasOpen || AttributesGui.swappedFromCurios) {
                atrComp.toggleVisibility();
            }
            AttributesGui.swappedFromCurios = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void effectGuiTooltips(GatherEffectScreenTooltipsEvent e) {
        String key;
        List tooltips = e.getTooltip();
        MobEffectInstance effectInst = e.getEffectInstance();
        Holder effect = effectInst.getEffect();
        MutableComponent name = (MutableComponent)tooltips.get(0);
        Component duration = (Component)tooltips.remove(1);
        duration = Component.translatable((String)"(%s)", (Object[])new Object[]{duration}).withStyle(ChatFormatting.WHITE);
        name.append(" ").append(duration);
        if (ApothicAttributes.getTooltipFlag().isAdvanced()) {
            name.append(" ").append((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{((ResourceKey)effect.unwrapKey().get()).location().toString()}).withStyle(ChatFormatting.GRAY));
        }
        if (I18n.exists((String)(key = ((MobEffect)effect.value()).getDescriptionId() + ".desc"))) {
            tooltips.add(Component.translatable((String)key).withStyle(ChatFormatting.DARK_GRAY));
        } else if (ApothicAttributes.getTooltipFlag().isAdvanced() && ((MobEffect)effect.value()).attributeModifiers.isEmpty()) {
            tooltips.add(Component.translatable((String)key).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
        ArrayList list = Lists.newArrayList();
        Map map = ((MobEffect)effect.value()).attributeModifiers;
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                MobEffect.AttributeTemplate template = (MobEffect.AttributeTemplate)entry.getValue();
                list.add(new Pair((Object)((Holder)entry.getKey()), (Object)template.create(effectInst.getAmplifier())));
            }
        }
        if (!list.isEmpty()) {
            for (Pair pair : list) {
                tooltips.add(((Attribute)((Holder)pair.getFirst()).value()).toComponent((AttributeModifier)pair.getSecond(), ApothicAttributes.getTooltipFlag()));
            }
        }
    }

    @SubscribeEvent
    public void potionTooltips(ItemTooltipEvent e) {
        List effects;
        if (!ALConfig.enablePotionTooltips) {
            return;
        }
        ItemStack stack = e.getItemStack();
        List tooltips = e.getToolTip();
        if (stack.getItem() instanceof PotionItem && (effects = ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).customEffects()).size() == 1 && tooltips.size() >= 2) {
            MobEffect effect = (MobEffect)((MobEffectInstance)effects.get(0)).getEffect().value();
            String key = effect.getDescriptionId() + ".desc";
            if (I18n.exists((String)key)) {
                tooltips.add(2, Component.translatable((String)key).withStyle(ChatFormatting.DARK_GRAY));
            } else if (e.getFlags().isAdvanced() && effect.attributeModifiers.isEmpty()) {
                tooltips.add(2, Component.translatable((String)key).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            }
        }
    }

    @SubscribeEvent
    public void commands(RegisterClientCommandsEvent e) {
        e.getDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"apothic_attributes_client").then(LiteralArgumentBuilder.literal((String)"set_btn_pos").then(((RequiredArgumentBuilder)Commands.argument((String)"anchor", (ArgumentType)StringArgumentType.string()).suggests(Offset.AnchorPoint.SUGGEST_ANCHOR_POINT).executes(c -> {
            AttributesLibClient.updateHudPos(Offset.AnchorPoint.parse((String)((String)c.getArgument("anchor", String.class))), 0, 0);
            return 0;
        })).then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer((int)-1000, (int)1000)).then(Commands.argument((String)"y", (ArgumentType)IntegerArgumentType.integer((int)-1000, (int)1000)).executes(c -> {
            AttributesLibClient.updateHudPos(Offset.AnchorPoint.parse((String)((String)c.getArgument("anchor", String.class))), (Integer)c.getArgument("x", Integer.class), (Integer)c.getArgument("y", Integer.class));
            return 0;
        }))))));
    }

    private static void updateHudPos(Offset.AnchorPoint anchor, int x, int y) {
        Configuration cfg = ALConfig.load();
        ALConfig.attributesGuiButtonOffset = new Offset(anchor, x, y);
        Offset.save((String)"GUI Button Offset", (String)"client", (Offset)ALConfig.attributesGuiButtonOffset, (Configuration)cfg);
    }

    public static void apothCrit(int entityId) {
        Entity entity = Minecraft.getInstance().level.getEntity(entityId);
        if (entity != null) {
            Minecraft.getInstance().particleEngine.createTrackingEmitter(entity, (ParticleOptions)ALObjects.Particles.APOTH_CRIT.get());
        }
    }

    public static class ApothCritParticle
    extends CritParticle {
        public ApothCritParticle(SimpleParticleType type, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            this.bCol = 1.0f;
            this.rCol = 0.3f;
            this.gCol = 0.8f;
        }
    }

    public static class ModBusSub {
        @SubscribeEvent
        public static void clientReload(RegisterClientReloadListenersEvent e) {
            e.registerReloadListener((PreparableReloadListener)ALConfig.makeReloader());
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent e) {
            if (ModList.get().isLoaded("curios")) {
                NeoForge.EVENT_BUS.register((Object)new CuriosClientCompat());
            }
        }

        @SubscribeEvent
        public static void particleFactories(RegisterParticleProvidersEvent e) {
            e.registerSprite((ParticleType)ALObjects.Particles.APOTH_CRIT.get(), ApothCritParticle::new);
        }
    }
}

