/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.screen;

import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.embeddedt.modernfix.screen.OptionList;

public class ModernFixConfigScreen
extends Screen {
    private OptionList optionList;
    private Screen lastScreen;
    public boolean madeChanges = false;
    private Button doneButton;
    private Button wikiButton;
    private double lastScrollAmount = 0.0;

    public ModernFixConfigScreen(Screen lastScreen) {
        super((Component)Component.translatable((String)"modernfix.config"));
        this.lastScreen = lastScreen;
    }

    protected void init() {
        this.optionList = new OptionList(this, this.minecraft);
        this.optionList.setScrollAmount(this.lastScrollAmount);
        this.addWidget((GuiEventListener)this.optionList);
        this.wikiButton = new Button.Builder((Component)Component.translatable((String)"modernfix.config.wiki"), arg -> Util.getPlatform().openUri("https://github.com/embeddedt/ModernFix/wiki/Summary-of-Patches")).pos(this.width / 2 - 155, this.height - 29).size(150, 20).build();
        this.doneButton = new Button.Builder(CommonComponents.GUI_DONE, arg -> this.onClose()).pos(this.width / 2 - 155 + 160, this.height - 29).size(150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.wikiButton);
        this.addRenderableWidget((GuiEventListener)this.doneButton);
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.optionList.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 8, 0xFFFFFF);
        this.doneButton.setMessage((Component)(this.madeChanges ? Component.translatable((String)"modernfix.config.done_restart") : CommonComponents.GUI_DONE));
    }

    public void setLastScrollAmount(double d) {
        this.lastScrollAmount = d;
    }
}

