/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.neoforge.init;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.neoforge.ModernFixConfig;
import org.embeddedt.modernfix.neoforge.init.ModernFixClientForge;
import org.embeddedt.modernfix.neoforge.packet.SmartIngredientSyncPayload;

@Mod(value="modernfix")
public class ModernFixForge {
    private static ModernFix commonMod;
    public static boolean launchDone;
    private static final List<Pair<List<String>, String>> MOD_WARNINGS;

    public ModernFixForge(ModContainer modContainer, IEventBus modBus) {
        commonMod = new ModernFix();
        NeoForge.EVENT_BUS.register((Object)this);
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::registerItems);
        modBus.addListener(this::registerNetworkChannel);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            NeoForge.EVENT_BUS.register((Object)new ModernFixClientForge(modContainer, modBus));
        }
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModernFixConfig.COMMON_CONFIG);
    }

    private void registerItems(RegisterEvent event) {
        if (Boolean.getBoolean("modernfix.largeRegistryTest")) {
            event.register(Registries.ITEM, helper -> {
                Item.Properties props = new Item.Properties();
                for (int i = 0; i < 1000000; ++i) {
                    helper.register(ResourceLocation.fromNamespaceAndPath((String)"modernfix", (String)("item_" + i)), (Object)new Item(props));
                }
            });
        }
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.warn_missing_perf_mods.Warnings")) {
            event.enqueueWork(() -> {
                boolean atLeastOneWarning = false;
                for (Pair<List<String>, String> warning : MOD_WARNINGS) {
                    boolean isPresent = !FMLLoader.isProduction() || ((List)warning.getLeft()).stream().anyMatch(name -> ModList.get().isLoaded(name));
                    if (isPresent) continue;
                    atLeastOneWarning = true;
                    ModLoader.addLoadingIssue((ModLoadingIssue)ModLoadingIssue.warning((String)((String)warning.getRight()), (Object[])new Object[0]));
                }
                if (atLeastOneWarning) {
                    ModLoader.addLoadingIssue((ModLoadingIssue)ModLoadingIssue.warning((String)"modernfix.perf_mod_warning", (Object[])new Object[0]));
                }
            });
        }
    }

    private void registerNetworkChannel(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1").optional();
        registrar.playToClient(SmartIngredientSyncPayload.TYPE, SmartIngredientSyncPayload.STREAM_CODEC, (payload, ctx) -> {});
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onServerDead(ServerStoppedEvent event) {
        commonMod.onServerDead(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onServerStarted(ServerStartedEvent event) {
        commonMod.onServerStarted();
    }

    static {
        launchDone = false;
        MOD_WARNINGS = ImmutableList.of((Object)Pair.of((Object)ImmutableList.of((Object)"ferritecore"), (Object)"modernfix.no_ferritecore"));
    }
}

