/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.luminax.datagen.assets;

import com.satherov.luminax.content.BlockSet;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class LuminaxBlockModelProvider
extends BlockModelProvider {
    public LuminaxBlockModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "luminax", existingFileHelper);
    }

    protected void registerModels() {
        BlockSet.apply(set -> {
            this.blockModel(set.BLOCK);
            this.slabModel(set.SLAB, set.BLOCK);
            this.stairModel(set.STAIRS, set.BLOCK);
            this.buttonModel(set.BUTTON, set.BLOCK);
            this.pressurePlateModel(set.PRESSURE_PLATE, set.BLOCK);
            this.wallModel(set.WALL, set.BLOCK);
            this.blockModel(set.DIM_BLOCK, set.BLOCK);
            this.slabModel(set.DIM_SLAB, set.BLOCK);
            this.stairModel(set.DIM_STAIRS, set.BLOCK);
            this.buttonModel(set.DIM_BUTTON, set.BLOCK);
            this.pressurePlateModel(set.DIM_PRESSURE_PLATE, set.BLOCK);
            this.wallModel(set.DIM_WALL, set.BLOCK);
        });
    }

    private ResourceLocation block(DeferredHolder<Block, ? extends Block> block) {
        return this.modLoc("block/" + block.getId().getPath());
    }

    private void blockModel(DeferredHolder<Block, ? extends Block> block) {
        this.singleTexture("block/" + block.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_block"), "texture", this.block(block));
    }

    private void blockModel(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> block2) {
        this.singleTexture("block/" + block.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_block"), "texture", this.block(block2));
    }

    private void slabModel(DeferredHolder<Block, ? extends SlabBlock> slab, DeferredHolder<Block, ? extends Block> block) {
        this.singleTexture("block/" + slab.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_slab"), "texture", this.block(block));
        this.singleTexture("block/" + slab.getId().getPath() + "_top", ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_slab_top"), "texture", this.block(block));
    }

    private void stairModel(DeferredHolder<Block, ? extends StairBlock> stair, DeferredHolder<Block, ? extends Block> block) {
        this.singleTexture("block/" + stair.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_stair"), "texture", this.block(block));
        this.singleTexture("block/" + stair.getId().getPath() + "_inner", ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_inner_stair"), "texture", this.block(block));
        this.singleTexture("block/" + stair.getId().getPath() + "_outer", ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_outer_stair"), "texture", this.block(block));
    }

    private void buttonModel(DeferredHolder<Block, ? extends ButtonBlock> button, DeferredHolder<Block, ? extends Block> block) {
        this.singleTexture("block/" + button.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_button"), "texture", this.block(block));
        this.singleTexture("block/" + button.getId().getPath() + "_pressed", ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_button_pressed"), this.block(block));
        this.singleTexture("block/" + button.getId().getPath() + "_inventory", ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_button_inventory"), "texture", this.block(block));
    }

    private void pressurePlateModel(DeferredHolder<Block, ? extends PressurePlateBlock> pressurePlate, DeferredHolder<Block, ? extends Block> block) {
        this.singleTexture("block/" + pressurePlate.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_pressure_plate_up"), "texture", this.block(block));
        this.singleTexture("block/" + pressurePlate.getId().getPath() + "_down", ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_pressure_plate_down"), "texture", this.block(block));
    }

    private void wallModel(DeferredHolder<Block, ? extends WallBlock> wall, DeferredHolder<Block, ? extends Block> block) {
        this.singleTexture("block/" + wall.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_wall_inventory"), "texture", this.block(block));
        this.singleTexture("block/" + wall.getId().getPath() + "_post", ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_wall_post"), "texture", this.block(block));
        this.singleTexture("block/" + wall.getId().getPath() + "_side", ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_wall_side"), "texture", this.block(block));
        this.singleTexture("block/" + wall.getId().getPath() + "_side_tall", ResourceLocation.fromNamespaceAndPath((String)"luminax", (String)"block/no_shade_wall_side_tall"), "texture", this.block(block));
    }
}

