/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.smithing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.CommonHooks;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.crafting.recipe.smithing.GearSmithingRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class CoatingSmithingRecipe
extends GearSmithingRecipe {
    public CoatingSmithingRecipe(ItemStack gearItem, Ingredient template, Ingredient addition) {
        super(gearItem, template, addition);
    }

    @Override
    protected ItemStack applyUpgrade(ItemStack gear, ItemStack upgradeItem) {
        GearType gearType;
        MaterialInstance material = MaterialInstance.from(upgradeItem);
        if (material != null && (gearType = GearHelper.getType(gear)).isGear()) {
            ItemStack result = gear.copy();
            ((PartType)PartTypes.COATING.get()).getCompoundPartItem(gearType).ifPresent(cpi -> {
                ItemStack partItem = cpi.create(material, 1);
                GearData.addOrReplacePart(result, Objects.requireNonNull(PartInstance.from(partItem)));
            });
            result.setDamageValue(0);
            GearData.recalculateGearData(result, CommonHooks.getCraftingPlayer());
            return result;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SgRecipes.SMITHING_COATING.get();
    }

    public static class Serializer
    implements RecipeSerializer<CoatingSmithingRecipe> {
        public static final MapCodec<CoatingSmithingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("gear").forGetter(r -> r.gearItem), (App)Ingredient.CODEC.fieldOf("template").forGetter(r -> r.template), (App)Ingredient.CODEC.fieldOf("addition").forGetter(r -> r.addition)).apply((Applicative)instance, CoatingSmithingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CoatingSmithingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, r -> r.gearItem, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.template, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.addition, CoatingSmithingRecipe::new);

        public MapCodec<CoatingSmithingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CoatingSmithingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

