/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.core.component;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.property.NumberPropertyValue;
import net.silentchaos512.gear.api.property.TraitListPropertyValue;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.CodecUtils;

public final class GearPropertiesData
extends Record {
    private final Map<GearProperty<?, ? extends GearPropertyValue<?>>, GearPropertyValue<?>> properties;
    public static final GearPropertiesData EMPTY = new GearPropertiesData(Collections.emptyMap());
    public static final Codec<GearPropertiesData> CODEC = Codec.dispatchedMap(CodecUtils.byModNameCodec(SgRegistries.GEAR_PROPERTY), GearProperty::codec).xmap(map -> {
        LinkedHashMap input = new LinkedHashMap((Map<GearProperty<?, ?>, GearPropertyValue<?>>)map);
        return new GearPropertiesData(input);
    }, data -> data.properties);
    public static final StreamCodec<RegistryFriendlyByteBuf, GearPropertiesData> STREAM_CODEC = StreamCodec.of(GearPropertiesData::encode, GearPropertiesData::decode);

    public GearPropertiesData(Map<GearProperty<?, ?>, GearPropertyValue<?>> properties) {
        this.properties = ImmutableMap.copyOf(properties);
    }

    @Nullable
    public <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> V get(Supplier<P> propertyType) {
        return this.get((GearProperty)propertyType.get());
    }

    public <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> V getOrDefault(Supplier<P> propertyType, V defaultValue) {
        return this.getOrDefault((GearProperty)propertyType.get(), defaultValue);
    }

    @Nullable
    public <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> V get(P propertyType) {
        return (V)this.properties.get(propertyType);
    }

    public <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> V getOrDefault(P propertyType, V defaultValue) {
        return (V)this.properties.getOrDefault(propertyType, defaultValue);
    }

    public float getNumber(Supplier<NumberProperty> propertyType) {
        return this.getNumber(propertyType, ((Float)propertyType.get().getDefaultValue()).floatValue());
    }

    public float getNumber(Supplier<NumberProperty> propertyType, float defaultValue) {
        NumberPropertyValue property = (NumberPropertyValue)this.get(propertyType.get());
        return property != null ? ((Float)property.value()).floatValue() : defaultValue;
    }

    public float getNumber(NumberProperty propertyType) {
        return this.getNumber(propertyType, ((Float)propertyType.getDefaultValue()).floatValue());
    }

    public float getNumber(NumberProperty propertyType, float defaultValue) {
        NumberPropertyValue property = (NumberPropertyValue)this.get(propertyType);
        return property != null ? ((Float)property.value()).floatValue() : defaultValue;
    }

    public int getNumberInt(Supplier<NumberProperty> propertyType) {
        return Math.round(this.getNumber(propertyType, ((Float)propertyType.get().getDefaultValue()).floatValue()));
    }

    public List<TraitInstance> getTraits() {
        return (List)this.getOrDefault((GearProperty)((Object)GearProperties.TRAITS), (GearPropertyValue)TraitListPropertyValue.empty()).value();
    }

    public boolean contains(GearProperty<?, ?> property) {
        return this.properties.containsKey(property);
    }

    private static void encode(RegistryFriendlyByteBuf buf, GearPropertiesData data) {
        buf.writeVarInt(data.properties.size());
        data.properties.forEach((property, value) -> {
            ResourceLocation key = SgRegistries.GEAR_PROPERTY.getKey(property);
            assert (key != null);
            buf.writeResourceLocation(key);
            property.rawStreamCodec().encode((Object)buf, value);
        });
    }

    private static GearPropertiesData decode(RegistryFriendlyByteBuf buf) {
        LinkedHashMap map = new LinkedHashMap();
        int count = buf.readVarInt();
        for (int i = 0; i < count; ++i) {
            GearProperty property = (GearProperty)SgRegistries.GEAR_PROPERTY.get(buf.readResourceLocation());
            assert (property != null);
            GearPropertyValue value = (GearPropertyValue)property.rawStreamCodec().decode((Object)buf);
            map.put(property, value);
        }
        return new GearPropertiesData(map);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{GearPropertiesData.class, "properties", "properties"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GearPropertiesData.class, "properties", "properties"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GearPropertiesData.class, "properties", "properties"}, this, o);
    }

    public Map<GearProperty<?, ? extends GearPropertyValue<?>>, GearPropertyValue<?>> properties() {
        return this.properties;
    }
}

