/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.util.GearGenerator;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.lib.util.PlayerUtils;

public final class RandomGearCommand {
    private static final SuggestionProvider<CommandSourceStack> itemIdSuggestions = (context, builder) -> SharedSuggestionProvider.suggestResource(BuiltInRegistries.ITEM.stream().filter(item -> item instanceof GearItem).map(NameUtils::fromItem), (SuggestionsBuilder)builder);

    private RandomGearCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgear_random_gear").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ResourceLocationArgument.id()).suggests(itemIdSuggestions).executes(context -> RandomGearCommand.run((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"players"), ResourceLocationArgument.getId((CommandContext)context, (String)"item"), 3))).then(Commands.argument((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> RandomGearCommand.run((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"players"), ResourceLocationArgument.getId((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier")))))));
    }

    private static int run(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players, ResourceLocation itemId, int tier) throws CommandSyntaxException {
        Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
        if (!(item instanceof GearItem)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.silentgear.randomGear.invalidItem"));
            return 0;
        }
        for (ServerPlayer player : players) {
            ItemStack stack = GearGenerator.create((GearItem)item);
            if (stack.isEmpty()) continue;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, stack.getDisplayName(), player.getDisplayName()}), true);
            PlayerUtils.giveItem((Player)player, (ItemStack)stack.copy());
        }
        return 1;
    }
}

