/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifier;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyGroups;
import net.silentchaos512.gear.api.property.GearPropertyMap;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.block.charger.ChargerBlockEntity;
import net.silentchaos512.gear.block.grader.GraderBlockEntity;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.AbstractGearPart;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.lib.util.Color;

public final class TooltipHandler {
    public static final TooltipHandler INSTANCE = new TooltipHandler();
    private static final boolean TRAIT_DISPLAY_CYCLE = false;
    public static final Color MC_DARK_GRAY;
    public static final Color MC_GRAY;

    private TooltipHandler() {
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onTooltip(ItemTooltipEvent event) {
        MaterialInstance material;
        ItemStack stack = event.getItemStack();
        if (stack.is(SgTags.Items.GRADER_CATALYSTS)) {
            TooltipHandler.onGraderCatalystTooltip(event);
        }
        if (stack.is(SgTags.Items.STARLIGHT_CHARGER_CATALYSTS)) {
            TooltipHandler.onStarlightChargerCatalystTooltip(event);
        }
        if ((material = MaterialInstance.from(stack)) != null) {
            TooltipHandler.onMaterialTooltip(event, stack, material);
            return;
        }
        PartInstance part = PartInstance.from(stack);
        if (part != null) {
            TooltipHandler.onPartTooltip(event, part);
            return;
        }
        if (Config.Common.isNerfedItem(stack.getItem())) {
            List toolTip = event.getToolTip();
            toolTip.add(Math.min(1, toolTip.size()), Component.translatable((String)"misc.silentgear.poorlyMade").withStyle(ChatFormatting.RED));
        }
    }

    private static void onGraderCatalystTooltip(ItemTooltipEvent event) {
        int tier = GraderBlockEntity.getCatalystTier(event.getItemStack());
        event.getToolTip().add(TextUtil.withColor(TextUtil.misc("graderCatalyst", tier), Color.DARKORANGE));
    }

    private static void onStarlightChargerCatalystTooltip(ItemTooltipEvent event) {
        int tier = ChargerBlockEntity.getStarlightChargerCatalystTier(event.getItemStack());
        event.getToolTip().add(TextUtil.withColor(TextUtil.misc("starlightChargerCataylst", tier), Color.REBECCAPURPLE));
    }

    private static void onMaterialTooltip(ItemTooltipEvent event, ItemStack stack, MaterialInstance material) {
        boolean keyHeld = KeyTracker.isDisplayPropertiesDown();
        if (event.getFlags().isAdvanced()) {
            event.getToolTip().add(Component.literal((String)("Material ID: " + String.valueOf(material.getId()))).withStyle(ChatFormatting.DARK_GRAY));
            event.getToolTip().add(Component.literal((String)("Material data pack: " + material.get().getPackName())).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (!((Boolean)Config.Client.showMaterialTooltips.get()).booleanValue()) {
            return;
        }
        if (keyHeld) {
            event.getToolTip().add(TextUtil.withColor(TextUtil.misc("tooltip.material", new Object[0]), Color.GOLD));
        } else {
            event.getToolTip().add(TextUtil.withColor(TextUtil.misc("tooltip.material", new Object[0]), Color.GOLD).append((Component)Component.literal((String)" ").append((Component)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_PROPERTIES), ChatFormatting.GRAY))));
        }
        TooltipHandler.getMaterialModifierLines(event, material);
        if (keyHeld) {
            TooltipHandler.getMaterialCategoriesLine(material).ifPresent(t -> event.getToolTip().add(t));
            List<PartType> partTypes = TooltipHandler.getSortedPartTypes(material.getPartTypes());
            if (!partTypes.isEmpty()) {
                int index = KeyTracker.getMaterialCycleIndex(partTypes.size());
                PartType partType = partTypes.get(index);
                event.getToolTip().add(TooltipHandler.buildPartTypeHeader(partTypes, partType));
                event.getToolTip().add(Component.translatable((String)"misc.silentgear.tooltip.properties").withStyle(ChatFormatting.GOLD));
                TooltipHandler.getMaterialStatLines(event, partType, material);
            }
        } else if (event.getFlags().isAdvanced()) {
            TooltipHandler.addJeiSearchTerms(event, material);
        }
    }

    private static List<PartType> getSortedPartTypes(Set<PartType> set) {
        ArrayList<PartType> result = new ArrayList<PartType>();
        for (PartType partType : SgRegistries.PART_TYPE) {
            if (!set.contains(partType)) continue;
            result.add(partType);
        }
        return result;
    }

    private static void addJeiSearchTerms(ItemTooltipEvent event, MaterialInstance material) {
        StringBuilder b = new StringBuilder();
        for (IMaterialCategory category : material.getCategories()) {
            b.append(category.getName()).append(" ");
        }
        HashSet<String> traits = new HashSet<String>();
        for (PartType partType : material.getPartTypes()) {
            b.append(partType.getDisplayName().getString()).append(" ");
            for (TraitInstance trait : material.getTraits(PartGearKey.ofAll(partType))) {
                traits.add(trait.getTrait().getDisplayName(0).getString());
            }
        }
        for (String str : traits) {
            b.append(str).append(" ");
        }
        event.getToolTip().add(Component.literal((String)b.toString().toLowerCase(Locale.ROOT)).withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
    }

    private static Optional<Component> getMaterialCategoriesLine(MaterialInstance material) {
        Collection<IMaterialCategory> categories = material.getCategories();
        if (!categories.isEmpty()) {
            MutableComponent text = TextUtil.separatedList(categories.stream().map(IMaterialCategory::getDisplayName).collect(Collectors.toList())).withStyle(ChatFormatting.ITALIC);
            return Optional.of(TextUtil.misc("materialCategories", text));
        }
        return Optional.empty();
    }

    private static Component buildPartTypeHeader(Collection<PartType> types, PartType selectedType) {
        MutableComponent ret = Component.literal((String)"| ").withStyle(ChatFormatting.GRAY);
        for (PartType type : types) {
            Color color = type == selectedType ? Color.AQUAMARINE : MC_DARK_GRAY;
            MutableComponent text = TextUtil.withColor(type.getDisplayName(), color);
            ret.append((Component)text).append(" | ");
        }
        MutableComponent keyHint = TextUtil.misc("tooltip.material.keyHint", TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_BACK), Color.AQUAMARINE), TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_NEXT), Color.AQUAMARINE));
        return ret.append((Component)keyHint);
    }

    private static void onPartTooltip(ItemTooltipEvent event, PartInstance part) {
        List<GearType> blacklist;
        if (event.getFlags().isAdvanced()) {
            event.getToolTip().add(Component.literal((String)("* Part ID: " + String.valueOf(part.getId()))).withStyle(ChatFormatting.DARK_GRAY));
            event.getToolTip().add(Component.literal((String)("* Part data pack: " + part.get().getPackName())).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (!((Boolean)Config.Client.showPartTooltips.get()).booleanValue()) {
            return;
        }
        event.getToolTip().add(TextUtil.withColor(part.getType().getDisplayName(), Color.AQUAMARINE));
        if (KeyTracker.isDisplayPropertiesDown()) {
            event.getToolTip().add(Component.translatable((String)"misc.silentgear.tooltip.properties").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)" (Silent Gear)").withStyle(ChatFormatting.RESET).withStyle(ChatFormatting.ITALIC)));
            TooltipHandler.getPartStatLines(event, part);
        } else {
            event.getToolTip().add(TextUtil.withColor(TextUtil.misc("tooltip.properties", new Object[0]), Color.GOLD).append((Component)Component.literal((String)" ").append((Component)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_PROPERTIES), ChatFormatting.GRAY))));
        }
        if (part.get() instanceof AbstractGearPart && !(blacklist = ((AbstractGearPart)part.get()).getBlacklistedGearTypes()).isEmpty()) {
            int index = ClientTicks.ticksInGame() / 20 % blacklist.size();
            GearType gearType = blacklist.get(index);
            Component blacklistedType = gearType.getDisplayName();
            event.getToolTip().add(Component.translatable((String)"misc.silentgear.tooltip.blacklist", (Object[])new Object[]{blacklistedType}).withStyle(ChatFormatting.RED));
        }
    }

    private static int getTraitDisplayIndex(int numTraits) {
        return -1;
    }

    private static void getMaterialModifierLines(ItemTooltipEvent event, MaterialInstance material) {
        for (IMaterialModifier modifier : material.getModifiers()) {
            modifier.appendTooltip(event.getToolTip());
        }
    }

    private static void getPartStatLines(ItemTooltipEvent event, PartInstance part) {
        GearType gearType = TooltipHandler.getPartGearType(part);
        TextListBuilder builder = new TextListBuilder();
        Set<GearProperty<?, ?>> sortedRelevantProperties = GearPropertyGroups.getSortedRelevantProperties(part.getGearType().relevantPropertyGroups());
        for (GearProperty<?, ?> property : sortedRelevantProperties) {
            ArrayList modifiers = new ArrayList(part.getPropertyModifiers(part.getType(), PropertyKey.of(property, gearType)));
            TooltipHandler.getStatTooltipLine(event, part.getGearType(), property, modifiers).ifPresent(builder::add);
        }
        event.getToolTip().addAll(builder.build());
    }

    private static GearType getPartGearType(PartInstance part) {
        GearType gearType;
        if (part.getItem().getItem() instanceof CompoundPartItem && (gearType = ((CompoundPartItem)part.getItem().getItem()).getGearType()).isGear()) {
            return gearType;
        }
        return (GearType)GearTypes.ALL.get();
    }

    private static void getMaterialStatLines(ItemTooltipEvent event, PartType partType, MaterialInstance material) {
        TextListBuilder builder = new TextListBuilder();
        for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
            TooltipHandler.getMaterialStatModLines(event, partType, material, builder, property);
        }
        event.getToolTip().addAll(builder.build());
    }

    private static <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> void getMaterialStatModLines(ItemTooltipEvent event, PartType partType, MaterialInstance material, TextListBuilder builder, P property) {
        Collection<GearPropertyValue<?>> modsAll = material.getPropertyModifiers(partType, PropertyKey.of(property, (GearType)GearTypes.ALL.get()));
        Optional<MutableComponent> head = TooltipHandler.getStatTooltipLine(event, (GearType)GearTypes.ALL.get(), property, modsAll);
        builder.add((Component)head.orElseGet(() -> TextUtil.withColor(property.getDisplayName(), property.getGroup().getColor())));
        builder.indent();
        int subCount = 0;
        List<PropertyKey> keysForStat = material.get().getPropertyKeys(material, partType).stream().filter(key -> key.property().equals(property)).toList();
        for (PropertyKey key2 : keysForStat) {
            if (key2.gearType() == GearTypes.ALL.get()) continue;
            PropertyKey castedKey = key2;
            Collection mods = material.getPropertyModifiers(partType, castedKey);
            Optional<MutableComponent> line = TooltipHandler.getSubStatTooltipLine(event, partType, castedKey.property(), key2.gearType(), mods);
            if (!line.isPresent()) continue;
            builder.add((Component)line.get());
            ++subCount;
        }
        if (subCount == 0 && head.isEmpty()) {
            builder.removeLast();
        }
        builder.unindent();
    }

    private static <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> Optional<MutableComponent> getStatTooltipLine(ItemTooltipEvent event, GearType gearType, GearProperty<?, ?> propertyIn, Collection<GearPropertyValue<?>> modifiersIn) {
        if (!modifiersIn.isEmpty()) {
            GearProperty<?, ?> property = propertyIn;
            Collection<GearPropertyValue<?>> modifiers = modifiersIn;
            Object value = property.compute(property.getZeroValue(), false, gearType, modifiers);
            boolean isZero = property.isZero(value);
            if (event.getFlags().isAdvanced() || !isZero) {
                Color nameColor = isZero ? MC_DARK_GRAY : property.getGroup().getColor();
                Color statColor = isZero ? MC_DARK_GRAY : Color.WHITE;
                MutableComponent nameStr = TextUtil.withColor(property.getDisplayName(), nameColor);
                MutableComponent uncoloredFormattedText = GearPropertyMap.formatText(modifiers, property, property.getPreferredDecimalPlaces(property.valueOf(value)));
                MutableComponent statListText = TextUtil.withColor(uncoloredFormattedText, statColor);
                return Optional.of(Component.translatable((String)"property.silentgear.displayFormat", (Object[])new Object[]{nameStr, statListText}));
            }
        }
        return Optional.empty();
    }

    private static <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> Optional<MutableComponent> getSubStatTooltipLine(ItemTooltipEvent event, PartType partType, P property, GearType gearType, Collection<V> modifiers) {
        if (!modifiers.isEmpty()) {
            T value = property.compute(property.getZeroValue(), modifiers);
            boolean isZero = property.isZero(value);
            if (event.getFlags().isAdvanced() || !isZero) {
                Color color = isZero ? MC_DARK_GRAY : Color.WHITE;
                MutableComponent nameStr = TextUtil.withColor(gearType.getDisplayName().copy(), color);
                MutableComponent uncoloredFormattedText = GearPropertyMap.formatText(modifiers, property, property.getPreferredDecimalPlaces(property.valueOf(value)));
                MutableComponent statListText = TextUtil.withColor(uncoloredFormattedText, color);
                return Optional.of(Component.translatable((String)"property.silentgear.displayFormat", (Object[])new Object[]{nameStr, statListText}));
            }
        }
        return Optional.empty();
    }

    static {
        assert (ChatFormatting.DARK_GRAY.getColor() != null);
        assert (ChatFormatting.GRAY.getColor() != null);
        MC_DARK_GRAY = new Color(ChatFormatting.DARK_GRAY.getColor().intValue());
        MC_GRAY = new Color(ChatFormatting.GRAY.getColor().intValue());
    }
}

