/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.silentchaos512.gear.api.item.GearTool;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearData;

public interface GearRangedWeapon
extends GearTool {
    public static final Supplier<Collection<PartType>> REQUIRED_PARTS = Suppliers.memoize(() -> ImmutableList.of((Object)((PartType)PartTypes.MAIN.get()), (Object)((PartType)PartTypes.ROD.get()), (Object)((PartType)PartTypes.CORD.get())));

    @Override
    default public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS.get();
    }

    default public float getBaseDrawDelay(ItemStack stack) {
        return 20.0f;
    }

    default public float getDrawDelay(ItemStack stack) {
        float speed = GearData.getProperties(stack).getNumber(GearProperties.DRAW_SPEED);
        if (speed <= 0.0f) {
            speed = 1.0f;
        }
        return this.getBaseDrawDelay(stack) / speed;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    default public ItemColor getItemColors() {
        return (stack, tintIndex) -> switch (tintIndex) {
            case 0 -> ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.ROD.get());
            case 1 -> ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.MAIN.get());
            case 3 -> ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.CORD.get());
            default -> -1;
        };
    }
}

