/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.TraitHelper;

public interface GearItem
extends ItemLike {
    public static final Supplier<Collection<PartType>> REQUIRED_PARTS = Suppliers.memoize(() -> ImmutableList.of((Object)((PartType)PartTypes.MAIN.get())));

    default public ItemStack construct(Collection<PartInstance> parts) {
        ItemStack result = new ItemStack((ItemLike)this);
        GearData.writeConstructionParts(result, parts);
        GearData.recalculateGearData(result, null);
        parts.forEach(p -> p.onAddToGear(result));
        TraitHelper.activateTraits(result, 0, (trait, value) -> {
            trait.getTrait().onGearCrafted(new TraitActionContext(null, trait, result));
            return 0;
        });
        return result;
    }

    default public Item asItem() {
        return (Item)this;
    }

    public GearType getGearType();

    default public boolean isValidSlot(String slot) {
        return false;
    }

    default public boolean requiresPartOfType(PartType type) {
        return this.getRequiredParts().contains(type);
    }

    default public boolean supportsPart(ItemStack gear, PartInstance part) {
        if (!part.isValid()) {
            return false;
        }
        boolean canAdd = part.get().canAddToGear(gear, part);
        return this.requiresPartOfType(part.getType()) && canAdd || canAdd;
    }

    default public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS.get();
    }

    default public Supplier<NumberProperty> getDurabilityStat() {
        return this.getGearType().durabilityStat();
    }

    default public float getRepairModifier(ItemStack stack) {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public ItemColor getItemColors() {
        return (stack, tintIndex) -> switch (tintIndex) {
            case 0 -> ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.ROD.get());
            case 1 -> {
                if (GearData.hasPartOfType(stack, (PartType)PartTypes.COATING.get())) {
                    yield ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.COATING.get());
                }
                yield ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.MAIN.get());
            }
            case 3 -> ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.TIP.get());
            case 4 -> ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.GRIP.get());
            default -> -1;
        };
    }
}

