/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.pocketstorage.commands;

import com.flanks255.pocketstorage.gui.PSUContainer;
import com.flanks255.pocketstorage.inventory.PSUData;
import com.flanks255.pocketstorage.inventory.StorageManager;
import com.flanks255.pocketstorage.util.PSUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;

public class Open {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"open").requires(cs -> cs.hasPermission(1))).then(Commands.argument((String)"UUID", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest(PSUtils.getUUIDSuggestions((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).executes(cs -> Open.open((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"UUID"))));
    }

    public static int open(CommandContext<CommandSourceStack> ctx, String stringUUID) throws CommandSyntaxException {
        UUID uuid;
        try {
            uuid = UUID.fromString(stringUUID);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
        StorageManager storageManager = StorageManager.get();
        if (storageManager.getMap().containsKey(uuid)) {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Optional<PSUData> data = storageManager.getStorage(uuid);
            data.ifPresent(psu -> player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new PSUContainer(windowId, playerInventory, uuid, psu.getHandler()), (Component)Component.literal((String)psu.getTier().name)), packetBuffer -> packetBuffer.writeNbt((Tag)psu.getHandler().serializeNBT((HolderLookup.Provider)((CommandSourceStack)ctx.getSource()).registryAccess())).writeUUID(uuid).writeInt(psu.getTier().ordinal())));
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"pocketstorage.util.invalid_uuid"));
        }
        return 0;
    }
}

