/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util.hnsw;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.util.BitSet;
import org.apache.lucene.ars_nouveau.util.hnsw.HnswGraph;
import org.apache.lucene.ars_nouveau.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.ars_nouveau.util.hnsw.NeighborArray;
import org.apache.lucene.ars_nouveau.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.ars_nouveau.util.hnsw.RandomVectorScorerSupplier;

public final class InitializedHnswGraphBuilder
extends HnswGraphBuilder {
    private final BitSet initializedNodes;

    public static InitializedHnswGraphBuilder fromGraph(RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, long seed, HnswGraph initializerGraph, int[] newOrdMap, BitSet initializedNodes, int totalNumberOfVectors) throws IOException {
        return new InitializedHnswGraphBuilder(scorerSupplier, M, beamWidth, seed, InitializedHnswGraphBuilder.initGraph(M, initializerGraph, newOrdMap, totalNumberOfVectors), initializedNodes);
    }

    public static OnHeapHnswGraph initGraph(int M, HnswGraph initializerGraph, int[] newOrdMap, int totalNumberOfVectors) throws IOException {
        OnHeapHnswGraph hnsw = new OnHeapHnswGraph(M, totalNumberOfVectors);
        for (int level = initializerGraph.numLevels() - 1; level >= 0; --level) {
            HnswGraph.NodesIterator it = initializerGraph.getNodesOnLevel(level);
            while (it.hasNext()) {
                int oldOrd = it.nextInt();
                int newOrd = newOrdMap[oldOrd];
                hnsw.addNode(level, newOrd);
                hnsw.trySetNewEntryNode(newOrd, level);
                NeighborArray newNeighbors = hnsw.getNeighbors(level, newOrd);
                initializerGraph.seek(level, oldOrd);
                int oldNeighbor = initializerGraph.nextNeighbor();
                while (oldNeighbor != Integer.MAX_VALUE) {
                    int newNeighbor = newOrdMap[oldNeighbor];
                    newNeighbors.addOutOfOrder(newNeighbor, Float.NaN);
                    oldNeighbor = initializerGraph.nextNeighbor();
                }
            }
        }
        return hnsw;
    }

    public InitializedHnswGraphBuilder(RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, long seed, OnHeapHnswGraph initializedGraph, BitSet initializedNodes) throws IOException {
        super(scorerSupplier, M, beamWidth, seed, initializedGraph);
        this.initializedNodes = initializedNodes;
    }

    @Override
    public void addGraphNode(int node) throws IOException {
        if (this.initializedNodes.get(node)) {
            return;
        }
        super.addGraphNode(node);
    }
}

