/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.sandbox.codecs.idversion;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.index.FieldInfo;
import org.apache.lucene.ars_nouveau.index.IndexOptions;
import org.apache.lucene.ars_nouveau.index.Terms;
import org.apache.lucene.ars_nouveau.index.TermsEnum;
import org.apache.lucene.ars_nouveau.sandbox.codecs.idversion.IDVersionSegmentTermsEnum;
import org.apache.lucene.ars_nouveau.sandbox.codecs.idversion.VersionBlockTreeTermsReader;
import org.apache.lucene.ars_nouveau.sandbox.codecs.idversion.VersionBlockTreeTermsWriter;
import org.apache.lucene.ars_nouveau.store.ByteArrayDataInput;
import org.apache.lucene.ars_nouveau.store.IndexInput;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.fst.FST;
import org.apache.lucene.ars_nouveau.util.fst.PairOutputs;

final class VersionFieldReader
extends Terms {
    final long numTerms;
    final FieldInfo fieldInfo;
    final long sumTotalTermFreq;
    final long sumDocFreq;
    final int docCount;
    final long indexStartFP;
    final long rootBlockFP;
    final PairOutputs.Pair<BytesRef, Long> rootCode;
    final BytesRef minTerm;
    final BytesRef maxTerm;
    final VersionBlockTreeTermsReader parent;
    final FST<PairOutputs.Pair<BytesRef, Long>> index;

    VersionFieldReader(VersionBlockTreeTermsReader parent, FieldInfo fieldInfo, long numTerms, PairOutputs.Pair<BytesRef, Long> rootCode, long sumTotalTermFreq, long sumDocFreq, int docCount, long indexStartFP, IndexInput indexIn, BytesRef minTerm, BytesRef maxTerm) throws IOException {
        assert (numTerms > 0L);
        this.fieldInfo = fieldInfo;
        this.parent = parent;
        this.numTerms = numTerms;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.sumDocFreq = sumDocFreq;
        this.docCount = docCount;
        this.indexStartFP = indexStartFP;
        this.rootCode = rootCode;
        this.minTerm = minTerm;
        this.maxTerm = maxTerm;
        this.rootBlockFP = new ByteArrayDataInput(((BytesRef)rootCode.output1).bytes, ((BytesRef)rootCode.output1).offset, ((BytesRef)rootCode.output1).length).readVLong() >>> 2;
        if (indexIn != null) {
            IndexInput clone = indexIn.clone();
            clone.seek(indexStartFP);
            this.index = new FST(FST.readMetadata(clone, VersionBlockTreeTermsWriter.FST_OUTPUTS), clone);
        } else {
            this.index = null;
        }
    }

    @Override
    public BytesRef getMin() throws IOException {
        if (this.minTerm == null) {
            return super.getMin();
        }
        return this.minTerm;
    }

    @Override
    public BytesRef getMax() throws IOException {
        if (this.maxTerm == null) {
            return super.getMax();
        }
        return this.maxTerm;
    }

    @Override
    public boolean hasFreqs() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
    }

    @Override
    public boolean hasOffsets() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    @Override
    public boolean hasPositions() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    @Override
    public boolean hasPayloads() {
        return this.fieldInfo.hasPayloads();
    }

    @Override
    public TermsEnum iterator() throws IOException {
        return new IDVersionSegmentTermsEnum(this);
    }

    @Override
    public long size() {
        return this.numTerms;
    }

    @Override
    public long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    @Override
    public long getSumDocFreq() {
        return this.sumDocFreq;
    }

    @Override
    public int getDocCount() {
        return this.docCount;
    }

    public String toString() {
        return "IDVersionTerms(terms=" + this.numTerms + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
    }
}

