/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.ars_nouveau.index.DirectoryReader;
import org.apache.lucene.ars_nouveau.index.IndexCommit;
import org.apache.lucene.ars_nouveau.index.IndexReader;
import org.apache.lucene.ars_nouveau.index.IndexWriter;
import org.apache.lucene.ars_nouveau.index.LeafReader;

public abstract class FilterDirectoryReader
extends DirectoryReader {
    protected final DirectoryReader in;

    public static DirectoryReader unwrap(DirectoryReader reader) {
        while (reader instanceof FilterDirectoryReader) {
            reader = ((FilterDirectoryReader)reader).getDelegate();
        }
        return reader;
    }

    public FilterDirectoryReader(DirectoryReader in, SubReaderWrapper wrapper) throws IOException {
        super(in.directory(), wrapper.wrap(in.getSequentialSubReaders()), null);
        this.in = in;
    }

    protected abstract DirectoryReader doWrapDirectoryReader(DirectoryReader var1) throws IOException;

    private final DirectoryReader wrapDirectoryReader(DirectoryReader in) throws IOException {
        return in == null ? null : this.doWrapDirectoryReader(in);
    }

    @Override
    protected final DirectoryReader doOpenIfChanged() throws IOException {
        return this.wrapDirectoryReader(this.in.doOpenIfChanged());
    }

    @Override
    protected final DirectoryReader doOpenIfChanged(IndexCommit commit) throws IOException {
        return this.wrapDirectoryReader(this.in.doOpenIfChanged(commit));
    }

    @Override
    protected final DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) throws IOException {
        return this.wrapDirectoryReader(this.in.doOpenIfChanged(writer, applyAllDeletes));
    }

    @Override
    public long getVersion() {
        return this.in.getVersion();
    }

    @Override
    public boolean isCurrent() throws IOException {
        return this.in.isCurrent();
    }

    @Override
    public IndexCommit getIndexCommit() throws IOException {
        return this.in.getIndexCommit();
    }

    @Override
    protected void doClose() throws IOException {
        this.in.close();
    }

    public DirectoryReader getDelegate() {
        return this.in;
    }

    public static abstract class SubReaderWrapper {
        protected LeafReader[] wrap(List<? extends LeafReader> readers) {
            LeafReader[] wrapped = new LeafReader[readers.size()];
            int i = 0;
            for (LeafReader leafReader : readers) {
                LeafReader wrap = this.wrap(leafReader);
                assert (wrap != null);
                wrapped[i++] = wrap;
            }
            return wrapped;
        }

        public abstract LeafReader wrap(LeafReader var1);
    }

    protected static class DelegatingCacheHelper
    implements IndexReader.CacheHelper {
        private final IndexReader.CacheHelper delegate;
        private final IndexReader.CacheKey cacheKey = new IndexReader.CacheKey();

        protected DelegatingCacheHelper(IndexReader.CacheHelper delegate) {
            this.delegate = delegate;
        }

        @Override
        public IndexReader.CacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public void addClosedListener(IndexReader.ClosedListener listener) {
            this.delegate.addClosedListener(unused -> listener.onClose(this.cacheKey));
        }
    }
}

