/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.geo;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.ars_nouveau.geo.Line;
import org.apache.lucene.ars_nouveau.geo.Polygon;
import org.apache.lucene.ars_nouveau.geo.Rectangle;

public class SimpleWKTShapeParser {
    public static final String EMPTY = "EMPTY";
    public static final String SPACE = " ";
    public static final String LPAREN = "(";
    public static final String RPAREN = ")";
    public static final String COMMA = ",";
    public static final String NAN = "NaN";
    private static final String NUMBER = "<NUMBER>";
    private static final String EOF = "END-OF-STREAM";
    private static final String EOL = "END-OF-LINE";

    private SimpleWKTShapeParser() {
    }

    public static Object parse(String wkt) throws IOException, ParseException {
        return SimpleWKTShapeParser.parseExpectedType(wkt, null);
    }

    public static Object parseExpectedType(String wkt, ShapeType shapeType) throws IOException, ParseException {
        try (StringReader reader = new StringReader(wkt);){
            StreamTokenizer tokenizer = new StreamTokenizer(reader);
            tokenizer.resetSyntax();
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(160, 255);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(45, 45);
            tokenizer.wordChars(43, 43);
            tokenizer.wordChars(46, 46);
            tokenizer.whitespaceChars(0, 32);
            tokenizer.commentChar(35);
            Object geometry = SimpleWKTShapeParser.parseGeometry(tokenizer, shapeType);
            SimpleWKTShapeParser.checkEOF(tokenizer);
            Object object = geometry;
            return object;
        }
    }

    private static Object parseGeometry(StreamTokenizer stream, ShapeType shapeType) throws IOException, ParseException {
        ShapeType type = ShapeType.forName(SimpleWKTShapeParser.nextWord(stream));
        if (shapeType != null && shapeType != ShapeType.GEOMETRYCOLLECTION && !type.wktName().equals(shapeType.wktName())) {
            throw new ParseException("Expected geometry type: [" + String.valueOf((Object)shapeType) + "], but found: [" + String.valueOf((Object)type) + "]", stream.lineno());
        }
        switch (type.ordinal()) {
            case 0: {
                return SimpleWKTShapeParser.parsePoint(stream);
            }
            case 1: {
                return SimpleWKTShapeParser.parseMultiPoint(stream);
            }
            case 2: {
                return SimpleWKTShapeParser.parseLine(stream);
            }
            case 3: {
                return SimpleWKTShapeParser.parseMultiLine(stream);
            }
            case 4: {
                return SimpleWKTShapeParser.parsePolygon(stream);
            }
            case 5: {
                return SimpleWKTShapeParser.parseMultiPolygon(stream);
            }
            case 7: {
                return SimpleWKTShapeParser.parseBBox(stream);
            }
            case 6: {
                return SimpleWKTShapeParser.parseGeometryCollection(stream);
            }
        }
        throw new IllegalArgumentException("Unknown geometry type: " + String.valueOf((Object)type));
    }

    private static double[] parsePoint(StreamTokenizer stream) throws IOException, ParseException {
        if (SimpleWKTShapeParser.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return null;
        }
        double[] pt = new double[]{SimpleWKTShapeParser.nextNumber(stream), SimpleWKTShapeParser.nextNumber(stream)};
        if (SimpleWKTShapeParser.isNumberNext(stream)) {
            SimpleWKTShapeParser.nextNumber(stream);
        }
        SimpleWKTShapeParser.nextCloser(stream);
        return pt;
    }

    private static void parseCoordinates(StreamTokenizer stream, ArrayList<Double> lats, ArrayList<Double> lons) throws IOException, ParseException {
        boolean isOpenParen = false;
        if (SimpleWKTShapeParser.isNumberNext(stream) || (isOpenParen = SimpleWKTShapeParser.nextWord(stream).equals(LPAREN))) {
            SimpleWKTShapeParser.parseCoordinate(stream, lats, lons);
        }
        while (SimpleWKTShapeParser.nextCloserOrComma(stream).equals(COMMA)) {
            isOpenParen = false;
            if (SimpleWKTShapeParser.isNumberNext(stream) || (isOpenParen = SimpleWKTShapeParser.nextWord(stream).equals(LPAREN))) {
                SimpleWKTShapeParser.parseCoordinate(stream, lats, lons);
            }
            if (!isOpenParen || SimpleWKTShapeParser.nextCloser(stream).equals(RPAREN)) continue;
            throw new ParseException("expected: [)] but found: [" + SimpleWKTShapeParser.tokenString(stream) + "]", stream.lineno());
        }
        if (isOpenParen && !SimpleWKTShapeParser.nextCloser(stream).equals(RPAREN)) {
            throw new ParseException("expected: [)] but found: [" + SimpleWKTShapeParser.tokenString(stream) + "]", stream.lineno());
        }
    }

    private static void parseCoordinate(StreamTokenizer stream, ArrayList<Double> lats, ArrayList<Double> lons) throws IOException, ParseException {
        lons.add(SimpleWKTShapeParser.nextNumber(stream));
        lats.add(SimpleWKTShapeParser.nextNumber(stream));
        if (SimpleWKTShapeParser.isNumberNext(stream)) {
            SimpleWKTShapeParser.nextNumber(stream);
        }
    }

    private static double[][] parseMultiPoint(StreamTokenizer stream) throws IOException, ParseException {
        String token = SimpleWKTShapeParser.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return null;
        }
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        SimpleWKTShapeParser.parseCoordinates(stream, lats, lons);
        double[][] result = new double[lats.size()][2];
        for (int i = 0; i < lats.size(); ++i) {
            result[i] = new double[]{lons.get(i), lats.get(i)};
        }
        return result;
    }

    private static Line parseLine(StreamTokenizer stream) throws IOException, ParseException {
        String token = SimpleWKTShapeParser.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return null;
        }
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        SimpleWKTShapeParser.parseCoordinates(stream, lats, lons);
        return new Line(lats.stream().mapToDouble(i -> i).toArray(), lons.stream().mapToDouble(i -> i).toArray());
    }

    private static Line[] parseMultiLine(StreamTokenizer stream) throws IOException, ParseException {
        String token = SimpleWKTShapeParser.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return null;
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(SimpleWKTShapeParser.parseLine(stream));
        while (SimpleWKTShapeParser.nextCloserOrComma(stream).equals(COMMA)) {
            lines.add(SimpleWKTShapeParser.parseLine(stream));
        }
        return lines.toArray(new Line[0]);
    }

    private static Polygon parsePolygonHole(StreamTokenizer stream) throws IOException, ParseException {
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        SimpleWKTShapeParser.parseCoordinates(stream, lats, lons);
        return new Polygon(lats.stream().mapToDouble(i -> i).toArray(), lons.stream().mapToDouble(i -> i).toArray(), new Polygon[0]);
    }

    private static Polygon parsePolygon(StreamTokenizer stream) throws IOException, ParseException {
        if (SimpleWKTShapeParser.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return null;
        }
        SimpleWKTShapeParser.nextOpener(stream);
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        SimpleWKTShapeParser.parseCoordinates(stream, lats, lons);
        ArrayList<Polygon> holes = new ArrayList<Polygon>();
        while (SimpleWKTShapeParser.nextCloserOrComma(stream).equals(COMMA)) {
            holes.add(SimpleWKTShapeParser.parsePolygonHole(stream));
        }
        if (!holes.isEmpty()) {
            return new Polygon(lats.stream().mapToDouble(i -> i).toArray(), lons.stream().mapToDouble(i -> i).toArray(), holes.toArray(new Polygon[0]));
        }
        return new Polygon(lats.stream().mapToDouble(i -> i).toArray(), lons.stream().mapToDouble(i -> i).toArray(), new Polygon[0]);
    }

    private static Polygon[] parseMultiPolygon(StreamTokenizer stream) throws IOException, ParseException {
        String token = SimpleWKTShapeParser.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return null;
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        polygons.add(SimpleWKTShapeParser.parsePolygon(stream));
        while (SimpleWKTShapeParser.nextCloserOrComma(stream).equals(COMMA)) {
            polygons.add(SimpleWKTShapeParser.parsePolygon(stream));
        }
        return polygons.toArray(new Polygon[0]);
    }

    private static Rectangle parseBBox(StreamTokenizer stream) throws IOException, ParseException {
        if (SimpleWKTShapeParser.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return null;
        }
        double minLon = SimpleWKTShapeParser.nextNumber(stream);
        SimpleWKTShapeParser.nextComma(stream);
        double maxLon = SimpleWKTShapeParser.nextNumber(stream);
        SimpleWKTShapeParser.nextComma(stream);
        double maxLat = SimpleWKTShapeParser.nextNumber(stream);
        SimpleWKTShapeParser.nextComma(stream);
        double minLat = SimpleWKTShapeParser.nextNumber(stream);
        SimpleWKTShapeParser.nextCloser(stream);
        return new Rectangle(minLat, maxLat, minLon, maxLon);
    }

    private static Object[] parseGeometryCollection(StreamTokenizer stream) throws IOException, ParseException {
        if (SimpleWKTShapeParser.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return null;
        }
        ArrayList<Object> geometries = new ArrayList<Object>();
        geometries.add(SimpleWKTShapeParser.parseGeometry(stream, ShapeType.GEOMETRYCOLLECTION));
        while (SimpleWKTShapeParser.nextCloserOrComma(stream).equals(COMMA)) {
            geometries.add(SimpleWKTShapeParser.parseGeometry(stream, null));
        }
        return geometries.toArray(new Object[0]);
    }

    private static String nextWord(StreamTokenizer stream) throws ParseException, IOException {
        switch (stream.nextToken()) {
            case -3: {
                String word = stream.sval;
                return word.equalsIgnoreCase(EMPTY) ? EMPTY : word;
            }
            case 40: {
                return LPAREN;
            }
            case 41: {
                return RPAREN;
            }
            case 44: {
                return COMMA;
            }
        }
        throw new ParseException("expected word but found: " + SimpleWKTShapeParser.tokenString(stream), stream.lineno());
    }

    private static double nextNumber(StreamTokenizer stream) throws IOException, ParseException {
        if (stream.nextToken() == -3) {
            if (stream.sval.equalsIgnoreCase(NAN)) {
                return Double.NaN;
            }
            try {
                return Double.parseDouble(stream.sval);
            }
            catch (NumberFormatException e) {
                throw new ParseException("invalid number found: " + stream.sval, stream.lineno());
            }
        }
        throw new ParseException("expected number but found: " + SimpleWKTShapeParser.tokenString(stream), stream.lineno());
    }

    private static String tokenString(StreamTokenizer stream) {
        switch (stream.ttype) {
            case -3: {
                return stream.sval;
            }
            case -1: {
                return EOF;
            }
            case 10: {
                return EOL;
            }
            case -2: {
                return NUMBER;
            }
        }
        return "'" + (char)stream.ttype + "'";
    }

    private static boolean isNumberNext(StreamTokenizer stream) throws IOException {
        int type = stream.nextToken();
        stream.pushBack();
        return type == -3;
    }

    private static String nextEmptyOrOpen(StreamTokenizer stream) throws IOException, ParseException {
        String next = SimpleWKTShapeParser.nextWord(stream);
        if (next.equals(EMPTY) || next.equals(LPAREN)) {
            return next;
        }
        throw new ParseException("expected EMPTY or ( but found: " + SimpleWKTShapeParser.tokenString(stream), stream.lineno());
    }

    private static String nextCloser(StreamTokenizer stream) throws IOException, ParseException {
        if (SimpleWKTShapeParser.nextWord(stream).equals(RPAREN)) {
            return RPAREN;
        }
        throw new ParseException("expected ) but found: " + SimpleWKTShapeParser.tokenString(stream), stream.lineno());
    }

    private static String nextComma(StreamTokenizer stream) throws IOException, ParseException {
        if (SimpleWKTShapeParser.nextWord(stream).equals(COMMA)) {
            return COMMA;
        }
        throw new ParseException("expected , but found: " + SimpleWKTShapeParser.tokenString(stream), stream.lineno());
    }

    private static String nextOpener(StreamTokenizer stream) throws IOException, ParseException {
        if (SimpleWKTShapeParser.nextWord(stream).equals(LPAREN)) {
            return LPAREN;
        }
        throw new ParseException("expected ( but found: " + SimpleWKTShapeParser.tokenString(stream), stream.lineno());
    }

    private static String nextCloserOrComma(StreamTokenizer stream) throws IOException, ParseException {
        String token = SimpleWKTShapeParser.nextWord(stream);
        if (token.equals(COMMA) || token.equals(RPAREN)) {
            return token;
        }
        throw new ParseException("expected , or ) but found: " + SimpleWKTShapeParser.tokenString(stream), stream.lineno());
    }

    private static void checkEOF(StreamTokenizer stream) throws ParseException, IOException {
        if (stream.nextToken() != -1) {
            throw new ParseException("expected end of WKT string but found additional text: " + SimpleWKTShapeParser.tokenString(stream), stream.lineno());
        }
    }

    public static enum ShapeType {
        POINT("point"),
        MULTIPOINT("multipoint"),
        LINESTRING("linestring"),
        MULTILINESTRING("multilinestring"),
        POLYGON("polygon"),
        MULTIPOLYGON("multipolygon"),
        GEOMETRYCOLLECTION("geometrycollection"),
        ENVELOPE("envelope");

        private final String shapeName;
        private static final Map<String, ShapeType> shapeTypeMap;
        private static final String BBOX = "BBOX";

        private ShapeType(String shapeName) {
            this.shapeName = shapeName;
        }

        String typename() {
            return this.shapeName;
        }

        public String wktName() {
            return this == ENVELOPE ? BBOX : this.shapeName;
        }

        public static ShapeType forName(String shapename) {
            String typename = shapename.toLowerCase(Locale.ROOT);
            ShapeType type = shapeTypeMap.get(typename);
            if (type != null) {
                return type;
            }
            throw new IllegalArgumentException("unknown geo_shape [" + shapename + "]");
        }

        static {
            HashMap<String, ShapeType> shapeTypes = new HashMap<String, ShapeType>();
            for (ShapeType type : ShapeType.values()) {
                shapeTypes.put(type.shapeName, type);
            }
            shapeTypes.put(ENVELOPE.wktName().toLowerCase(Locale.ROOT), ENVELOPE);
            shapeTypeMap = Collections.unmodifiableMap(shapeTypes);
        }
    }
}

