/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.morph;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.ars_nouveau.analysis.morph.BinaryDictionary;
import org.apache.lucene.ars_nouveau.analysis.morph.DictionaryEntryWriter;
import org.apache.lucene.ars_nouveau.analysis.morph.MorphData;
import org.apache.lucene.ars_nouveau.codecs.CodecUtil;
import org.apache.lucene.ars_nouveau.store.OutputStreamDataOutput;
import org.apache.lucene.ars_nouveau.util.ArrayUtil;

public abstract class BinaryDictionaryWriter<T extends BinaryDictionary<? extends MorphData>> {
    private final Class<T> implClazz;
    private int targetMapEndOffset = 0;
    private int lastWordId = -1;
    private int lastSourceId = -1;
    private int[] targetMap = new int[8192];
    private int[] targetMapOffsets = new int[8192];
    protected final DictionaryEntryWriter entryWriter;

    protected BinaryDictionaryWriter(Class<T> implClazz, DictionaryEntryWriter entryWriter) {
        this.implClazz = implClazz;
        this.entryWriter = entryWriter;
    }

    public int put(String[] entry) {
        return this.entryWriter.putEntry(entry);
    }

    public abstract void write(Path var1) throws IOException;

    protected void addMapping(int sourceId, int wordId) {
        if (wordId <= this.lastWordId) {
            throw new IllegalStateException("words out of order: " + wordId + " vs lastID: " + this.lastWordId);
        }
        if (sourceId > this.lastSourceId) {
            this.targetMapOffsets = ArrayUtil.grow(this.targetMapOffsets, sourceId + 1);
            for (int i = this.lastSourceId + 1; i <= sourceId; ++i) {
                this.targetMapOffsets[i] = this.targetMapEndOffset;
            }
        } else if (sourceId != this.lastSourceId) {
            throw new IllegalStateException("source ids not in increasing order: lastSourceId=" + this.lastSourceId + " vs sourceId=" + sourceId);
        }
        this.targetMap = ArrayUtil.grow(this.targetMap, this.targetMapEndOffset + 1);
        this.targetMap[this.targetMapEndOffset] = wordId;
        ++this.targetMapEndOffset;
        this.lastSourceId = sourceId;
        this.lastWordId = wordId;
    }

    protected void write(Path baseDir, String targetMapCodecHeader, String posDictCodecHeader, String dictCodecHeader, int dictCodecVersion) throws IOException {
        String baseName = this.getBaseFileName();
        this.entryWriter.writeDictionary(baseDir.resolve(baseName + "$buffer.dat"), dictCodecHeader, dictCodecVersion);
        this.entryWriter.writePosDict(baseDir.resolve(baseName + "$posDict.dat"), posDictCodecHeader, dictCodecVersion);
        this.writeTargetMap(baseDir.resolve(baseName + "$targetMap.dat"), targetMapCodecHeader, dictCodecVersion);
    }

    protected final String getBaseFileName() {
        return this.implClazz.getName().replace('.', '/');
    }

    private void writeTargetMap(Path path, String targetMapCodecHeader, int dictCodecVersion) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            OutputStreamDataOutput out = new OutputStreamDataOutput(bos);
            CodecUtil.writeHeader(out, targetMapCodecHeader, dictCodecVersion);
            int numSourceIds = this.lastSourceId + 1;
            out.writeVInt(this.targetMapEndOffset);
            out.writeVInt(numSourceIds + 1);
            int prev = 0;
            int sourceId = 0;
            for (int ofs = 0; ofs < this.targetMapEndOffset; ++ofs) {
                int val = this.targetMap[ofs];
                int delta = val - prev;
                assert (delta >= 0);
                if (ofs == this.targetMapOffsets[sourceId]) {
                    out.writeVInt(delta << 1 | 1);
                    ++sourceId;
                } else {
                    out.writeVInt(delta << 1);
                }
                prev += delta;
            }
            if (sourceId != numSourceIds) {
                throw new IllegalStateException("sourceId:" + sourceId + " != numSourceIds:" + numSourceIds);
            }
        }
    }
}

