/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.util;

import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.setup.config.ConfigUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;

public class SpellPartConfigUtil {
    private static final Pattern AUGMENT_LIMITS_PATTERN = Pattern.compile("([^/=]+)=(\\d+)");

    public static AugmentLimits buildAugmentLimitsConfig(ModConfigSpec.Builder builder, Map<ResourceLocation, Integer> defaults) {
        ModConfigSpec.ConfigValue configValue = builder.comment(new String[]{"Limits the number of times a given augment may be applied to a given effect", "Example entry: \"" + GlyphLib.AugmentAmplifyID + "=5\""}).defineList("augment_limits", SpellPartConfigUtil.writeAugmentConfig(defaults), SpellPartConfigUtil::validateAugmentLimits);
        return new AugmentLimits((ModConfigSpec.ConfigValue<List<? extends String>>)configValue);
    }

    public static ComboLimits buildInvalidCombosConfig(ModConfigSpec.Builder builder, Set<ResourceLocation> defaults) {
        ModConfigSpec.ConfigValue configValue = builder.comment(new String[]{"Prevents the given glyph from being used in the same spell as the given glyph", "Example entry: \"" + GlyphLib.EffectBurstID + "\""}).defineList("invalid_combos", SpellPartConfigUtil.writeComboConfig(defaults), o -> {
            String s;
            return o instanceof String && ResourceLocation.read((String)(s = (String)o)).isSuccess();
        });
        return new ComboLimits((ModConfigSpec.ConfigValue<List<? extends String>>)configValue);
    }

    private static List<String> writeComboConfig(Set<ResourceLocation> augmentLimits) {
        return augmentLimits.stream().map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public static AugmentCosts buildAugmentCosts(ModConfigSpec.Builder builder, Map<ResourceLocation, Integer> defaults) {
        ModConfigSpec.ConfigValue configValue = builder.comment(new String[]{"How much an augment should cost when used on this effect or form. This overrides the default cost in the augment config.", "Example entry: \"" + GlyphLib.AugmentAmplifyID + "=50\""}).defineList("augment_cost_overrides", ConfigUtil.writeResConfig(defaults), SpellPartConfigUtil::validateAugmentLimits);
        return new AugmentCosts((ModConfigSpec.ConfigValue<List<? extends String>>)configValue);
    }

    private static List<String> writeAugmentConfig(Map<ResourceLocation, Integer> augmentLimits) {
        return augmentLimits.entrySet().stream().map(e -> ((ResourceLocation)e.getKey()).toString() + "=" + ((Integer)e.getValue()).toString()).collect(Collectors.toList());
    }

    private static boolean validateAugmentLimits(Object rawConfig) {
        if (rawConfig instanceof CharSequence) {
            return AUGMENT_LIMITS_PATTERN.matcher((CharSequence)rawConfig).matches();
        }
        return false;
    }

    public static class AugmentLimits {
        private ModConfigSpec.ConfigValue<List<? extends String>> configValue;

        private AugmentLimits(ModConfigSpec.ConfigValue<List<? extends String>> configValue) {
            this.configValue = configValue;
        }

        public int getAugmentLimit(ResourceLocation augmentTag) {
            Map<ResourceLocation, Integer> limits = this.parseAugmentLimits();
            return limits.getOrDefault(augmentTag, Integer.MAX_VALUE);
        }

        private Map<ResourceLocation, Integer> parseAugmentLimits() {
            return ((List)this.configValue.get()).stream().map(AUGMENT_LIMITS_PATTERN::matcher).filter(Matcher::matches).collect(Collectors.toMap(m -> ResourceLocation.tryParse((String)m.group(1)), m -> Integer.valueOf(m.group(2))));
        }
    }

    public static class ComboLimits {
        private final ModConfigSpec.ConfigValue<List<? extends String>> configValue;

        public ComboLimits(ModConfigSpec.ConfigValue<List<? extends String>> configValue) {
            this.configValue = configValue;
        }

        public boolean contains(ResourceLocation glyphTag) {
            return this.parseComboLimits().contains(glyphTag);
        }

        public Set<ResourceLocation> parseComboLimits() {
            if (this.configValue == null) {
                return new HashSet<ResourceLocation>();
            }
            return ((List)this.configValue.get()).stream().map(ResourceLocation::tryParse).collect(Collectors.toSet());
        }
    }

    public static class AugmentCosts {
        private Map<ResourceLocation, Integer> costs = null;
        private ModConfigSpec.ConfigValue<List<? extends String>> configValue;

        private AugmentCosts(ModConfigSpec.ConfigValue<List<? extends String>> configValue) {
            this.configValue = configValue;
        }

        public int getAugmentCost(ResourceLocation effectTag, int fallback) {
            this.costs = this.parseAugmentCosts();
            return this.costs.getOrDefault(effectTag, fallback);
        }

        private Map<ResourceLocation, Integer> parseAugmentCosts() {
            return ((List)this.configValue.get()).stream().map(AUGMENT_LIMITS_PATTERN::matcher).filter(Matcher::matches).collect(Collectors.toMap(m -> ResourceLocation.tryParse((String)m.group(1)), m -> Integer.valueOf(m.group(2))));
        }
    }
}

