/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.block.tile.BasicSpellTurretTile;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectLeap
extends AbstractEffect {
    public static EffectLeap INSTANCE = new EffectLeap();
    ModConfigSpec.BooleanValue NERF;

    private EffectLeap() {
        super(GlyphLib.EffectLeapID, "Leap");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        double bonus;
        Vec3 vector;
        Entity entity = rayTraceResult.getEntity();
        if (((Boolean)this.NERF.get()).booleanValue() && entity == shooter && !shooter.onGround()) {
            return;
        }
        if (entity instanceof LivingEntity) {
            vector = entity.getLookAngle();
            bonus = Math.max(0.0, (Double)this.GENERIC_DOUBLE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
        } else {
            vector = EffectLeap.getLookVector(shooter, spellContext);
            bonus = (Double)this.GENERIC_DOUBLE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier();
        }
        entity.setDeltaMovement(vector.x * bonus, vector.y * bonus, vector.z * bonus);
        entity.fallDistance = 0.0f;
        entity.hurtMarked = true;
    }

    public static Vec3 getLookVector(@NotNull LivingEntity shooter, SpellContext spellContext) {
        Vec3 vector = shooter.getLookAngle();
        IWrappedCaster iWrappedCaster = spellContext.getCaster();
        if (iWrappedCaster instanceof TileCaster) {
            TileCaster tc = (TileCaster)iWrappedCaster;
            BlockEntity tile = tc.getTile();
            if (tile instanceof RotatingTurretTile) {
                RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)tile;
                vector = rotatingTurretTile.getShootAngle();
            } else if (tile instanceof BasicSpellTurretTile || tile instanceof RuneTile) {
                vector = new Vec3(((Direction)tile.getBlockState().getValue((Property)BlockStateProperties.FACING)).step());
            }
        }
        return vector;
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (spellStats.isSensitive()) {
            return;
        }
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, rayTraceResult.getBlockPos(), rayTraceResult, spellStats);
        for (BlockPos pos1 : posList) {
            EnchantedFallingBlock entity = EnchantedFallingBlock.fall(world, pos1, (Entity)shooter, spellContext, resolver, spellStats);
            if (entity == null) continue;
            Vec3 vector = EffectLeap.getLookVector(shooter, spellContext);
            double bonus = (Double)this.GENERIC_DOUBLE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier();
            entity.setDeltaMovement(vector.x * bonus, vector.y * bonus, vector.z * bonus);
            entity.hurtMarked = true;
            entity.fallDistance = 0.0f;
            ShapersFocus.tryPropagateEntitySpell(entity, world, (Entity)shooter, spellContext, resolver);
        }
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.NERF = builder.comment("If true, will not launch the caster if they are not on the ground.").define("force_ground", false);
        this.addGenericDouble(builder, 1.5, "Base knockup amount", "knock_up");
        this.addAmpConfig(builder, 1.0);
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentSensitive.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Launches the target in the direction they are looking. Amplification will increase the distance moved.";
    }

    @Override
    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        this.addBlockAoeAugmentDescriptions(map);
        map.put(AugmentAmplify.INSTANCE, "Increases the velocity.");
        map.put(AugmentDampen.INSTANCE, "Decreases the velocity.");
        map.put(AugmentSensitive.INSTANCE, "Prevents blocks from being moved.");
    }

    @Override
    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        super.addDefaultAugmentLimits(defaults);
        defaults.put(AugmentSensitive.INSTANCE.getRegistryName(), 1);
    }

    @Override
    public int getDefaultManaCost() {
        return 25;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_AIR);
    }
}

