/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.chimera;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.entity.WildenChimera;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraSpikeGoal;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.EnumSet;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ChimeraDiveGoal
extends Goal {
    WildenChimera boss;
    boolean finished;
    int ticksFlying;
    boolean isDiving;
    BlockPos divePos;
    BlockPos startPos;
    BlockPos hoverPos;

    public ChimeraDiveGoal(WildenChimera boss) {
        this.boss = boss;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        super.start();
        this.finished = false;
        this.divePos = null;
        this.ticksFlying = 0;
        this.isDiving = false;
        this.startPos = this.boss.blockPosition();
        this.hoverPos = this.startPos.above(8);
        this.boss.setFlying(true);
        this.boss.getNavigation().setCanFloat(true);
        Networking.sendToNearbyClient(this.boss.level, (Entity)this.boss, (CustomPacketPayload)new PacketAnimEntity(this.boss.getId(), WildenChimera.Animations.FLYING.ordinal()));
    }

    public void stop() {
        super.stop();
        this.tearDownNavigation();
    }

    public void tick() {
        super.tick();
        ++this.ticksFlying;
        if (this.ticksFlying < 60) {
            this.boss.flyingNavigator.moveTo((double)this.hoverPos.getX(), (double)this.hoverPos.getY(), (double)this.hoverPos.getZ(), 1.0);
            this.boss.setDeltaMovement(this.boss.getDeltaMovement().add(0.0, 0.005, 0.0));
            if (this.boss.getTarget() != null) {
                WildenChimera.faceBlock(this.boss.getTarget().blockPosition(), (LivingEntity)this.boss);
            }
        }
        if (this.ticksFlying > 60) {
            this.boss.setDiving(true);
            this.isDiving = true;
            this.boss.diving = true;
            if (this.divePos == null && this.boss.getTarget() != null) {
                this.divePos = this.boss.getTarget().blockPosition().below();
                for (int i = 1; i < 50 && this.boss.level.getBlockState(this.divePos).isAir(); ++i) {
                    this.divePos = this.divePos.below();
                }
            }
            if (this.divePos != null) {
                this.boss.flyingNavigator.moveTo((double)this.divePos.getX() + 0.5, (double)this.divePos.getY(), (double)this.divePos.getZ(), 4.0);
                this.boss.orbitOffset = new Vec3((double)this.divePos.getX() + 0.5, (double)this.divePos.getY(), (double)this.divePos.getZ() + 0.5);
            }
        }
        if (this.isDiving && (this.boss.onGround() || BlockUtil.distanceFrom(this.boss.position, this.divePos) <= 1.0) || this.boss.orbitOffset != null && BlockUtil.distanceFrom(this.boss.position, this.boss.orbitOffset) <= 1.7) {
            this.makeExplosion();
            this.endGoal();
            return;
        }
        if (this.isDiving && (this.boss.isInWall() || this.boss.horizontalCollision || this.boss.verticalCollision)) {
            this.makeExplosion();
            this.endGoal();
            return;
        }
        if (this.isDiving && this.divePos == null && this.boss.getTarget() == null) {
            this.endGoal();
        }
    }

    public void endGoal() {
        this.tearDownNavigation();
        this.boss.diveCooldown = (int)(300.0 + ParticleUtil.inRange(-100.0, 100.0) + (double)this.boss.getCooldownModifier());
        this.boss.diving = false;
        this.finished = true;
        ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)ANCriteriaTriggers.CHIMERA_EXPLOSION.get(), (ServerLevel)this.boss.level, BlockPos.containing((double)this.boss.position().x, (double)this.boss.position.y, (double)this.boss.position.z), 10);
        for (int i = 0; i < 40; ++i) {
            if (this.boss.level.getBlockState(this.boss.getOnPos().below(i)).isAir()) continue;
            this.boss.setPos(this.boss.getX(), this.boss.getY() - (double)i, this.boss.getZ());
            this.boss.setOnGround(true);
            return;
        }
    }

    public void makeExplosion() {
        this.boss.level.explode((Entity)this.boss, this.boss.getX() + 0.5, this.boss.getY(), this.boss.getZ() + 0.5, 4.5f, Level.ExplosionInteraction.MOB);
        if (this.boss.hasSpikes()) {
            ChimeraSpikeGoal.spawnAOESpikes(this.boss);
        }
    }

    public void tearDownNavigation() {
        this.boss.getNavigation().setCanFloat(false);
        this.boss.getNavigation().stop();
        this.boss.setFlying(false);
        this.boss.setDiving(false);
        this.boss.setNoGravity(false);
        this.boss.setDeltaMovement(0.0, 0.0, 0.0);
    }

    public boolean canContinueToUse() {
        boolean canContinue;
        boolean bl = canContinue = !this.finished && !this.boss.getPhaseSwapping();
        if (!canContinue) {
            this.tearDownNavigation();
        }
        return canContinue;
    }

    public boolean canUse() {
        return this.boss.canDive() && this.boss.getTarget() != null;
    }
}

