/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.bookwyrm;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class RandomStorageVisitGoal
extends Goal {
    public BlockPos target;
    public int ticksRunning;
    public boolean arrived;
    public int arrivedTicks;
    public boolean isDone;
    public EntityBookwyrm bookwyrm;
    public Supplier<BlockPos> getTarget;

    public RandomStorageVisitGoal(EntityBookwyrm bookwyrm, Supplier<BlockPos> getTarget) {
        this.bookwyrm = bookwyrm;
        this.getTarget = getTarget;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public void start() {
        this.target = this.getTarget.get();
        this.ticksRunning = 0;
        this.arrived = false;
        this.arrivedTicks = 0;
        this.isDone = false;
        this.bookwyrm.backoffTicks = 100 + this.bookwyrm.level.random.nextInt(100);
    }

    public void tick() {
        if (this.target == null) {
            return;
        }
        ++this.ticksRunning;
        if (!this.arrived) {
            Vec3 vec3 = new Vec3((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5);
            if (BlockUtil.distanceFrom(this.bookwyrm.position, vec3) < 1.5) {
                this.arrived = true;
            }
            this.bookwyrm.getNavigation().moveTo((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, 1.2);
        } else {
            ++this.arrivedTicks;
            if (this.arrivedTicks > 100) {
                this.isDone = true;
            }
        }
    }

    public boolean canContinueToUse() {
        return this.target != null && this.ticksRunning < 200 && !this.isDone && !this.bookwyrm.playerTooFar;
    }

    public boolean canUse() {
        return !this.bookwyrm.playerTooFar && this.bookwyrm.backoffTicks <= 0 && this.bookwyrm.getRandom().nextInt(4) == 0;
    }
}

