/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.source.SourcelinkEventQueue;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="ars_nouveau")
public class VitalicSourcelinkTile
extends SourcelinkTile {
    private static final String TAG_POISONED = "quark:poison_potato_applied";

    public VitalicSourcelinkTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public VitalicSourcelinkTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.VITALIC_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide && this.level.getGameTime() % 60L == 0L) {
            for (AgeableMob entity : this.level.getEntitiesOfClass(AgeableMob.class, new AABB(this.worldPosition).inflate(6.0))) {
                if (entity.getType().is(EntityTags.VITALIC_GROWTH_BLACKLIST) || !entity.isBaby() || entity.getAge() >= 0) continue;
                if (ModList.get().isLoaded("quark") && entity.getPersistentData().contains(TAG_POISONED)) {
                    return;
                }
                entity.setAge(Math.min(0, entity.getAge() + 500));
                this.addSource(10);
                ParticleUtil.spawnFollowProjectile(this.level, entity.blockPosition(), this.worldPosition, this.getColor());
            }
        }
    }

    @SubscribeEvent
    public static void babySpawnEvent(BabyEntitySpawnEvent e) {
        int mana = 600;
        SourcelinkEventQueue.addManaEvent(e.getParentA().level, VitalicSourcelinkTile.class, mana, (Event)e, e.getParentA().blockPosition());
    }

    @SubscribeEvent
    public static void livingDeath(LivingDeathEvent event) {
        LivingEntity e = event.getEntity();
        if (e.level.isClientSide || e instanceof IDispellable || e instanceof ISummon || e.getType().is(EntityTags.VITALIC_DEATH_BLACKLIST)) {
            return;
        }
        int mana = 200;
        SourcelinkEventQueue.addManaEvent(e.level, VitalicSourcelinkTile.class, mana, (Event)event, e.blockPosition());
    }

    @Override
    public boolean usesEventQueue() {
        return true;
    }
}

