/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.common.block.ArcanePedestal;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import org.joml.Vector3f;

public class ArcanePedestalRenderer
implements BlockEntityRenderer<ArcanePedestalTile> {
    private final EntityRenderDispatcher entityRenderer;

    public ArcanePedestalRenderer(BlockEntityRendererProvider.Context pContext) {
        this.entityRenderer = pContext.getEntityRenderer();
    }

    public void render(ArcanePedestalTile tileEntityIn, float pPartialTick, PoseStack matrixStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (tileEntityIn.getStack() == null || tileEntityIn.getStack().isEmpty()) {
            return;
        }
        Block block = tileEntityIn.getBlockState().getBlock();
        if (!(block instanceof ArcanePedestal)) {
            return;
        }
        ArcanePedestal pedestal = (ArcanePedestal)block;
        Vector3f offsetVec = pedestal.getItemOffset(tileEntityIn.getBlockState(), tileEntityIn.getBlockPos());
        float yOffset = offsetVec.y - (float)tileEntityIn.getBlockPos().getY();
        float xOffset = offsetVec.x - (float)tileEntityIn.getBlockPos().getX();
        float zOffset = offsetVec.z - (float)tileEntityIn.getBlockPos().getZ();
        matrixStack.pushPose();
        matrixStack.translate(xOffset, yOffset, zOffset);
        matrixStack.scale(0.5f, 0.5f, 0.5f);
        matrixStack.mulPose(Axis.YP.rotationDegrees((pPartialTick + (float)ClientInfo.ticksInGame) * 3.0f));
        Minecraft.getInstance().getItemRenderer().renderStatic(tileEntityIn.getStack(), ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, matrixStack, pBufferSource, tileEntityIn.getLevel(), (int)tileEntityIn.getBlockPos().asLong());
        matrixStack.popPose();
    }
}

