/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.documentation;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocPlayerData;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.client.gui.SearchBar;
import com.hollingsworth.arsnouveau.client.gui.documentation.BookmarkButton;
import com.hollingsworth.arsnouveau.client.gui.documentation.IndexScreen;
import com.hollingsworth.arsnouveau.client.gui.documentation.PageHolderScreen;
import com.hollingsworth.arsnouveau.client.gui.documentation.SearchScreen;
import com.hollingsworth.nuggets.client.gui.BaseButton;
import com.hollingsworth.nuggets.client.gui.BaseScreen;
import com.hollingsworth.nuggets.client.gui.NuggetImageButton;
import com.mojang.blaze3d.platform.InputConstants;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;

public class BaseDocScreen
extends BaseScreen {
    public NuggetImageButton leftArrow;
    public NuggetImageButton rightArrow;
    public BaseButton backButton;
    public int arrowIndex;
    public int maxArrowIndex;
    public SearchBar searchBar;
    public String previousString = "";
    public BaseDocScreen previousScreen = null;
    SoundManager manager = Minecraft.getInstance().getSoundManager();
    List<AbstractWidget> bookmarkButtons = new ArrayList<AbstractWidget>();
    public static final int LEFT_PAGE_OFFSET = 19;
    public static final int RIGHT_PAGE_OFFSET = 153;
    public static final int PAGE_TOP_OFFSET = 17;
    public static final int ONE_PAGE_WIDTH = 118;
    public static final int ONE_PAGE_HEIGHT = 146;

    public BaseDocScreen() {
        super((Component)Component.empty(), DocAssets.BACKGROUND.width(), DocAssets.BACKGROUND.height(), DocAssets.BACKGROUND.location());
    }

    public void init() {
        super.init();
        this.searchBar = new SearchBar(this.minecraft.font, this.screenRight - 130, this.screenTop - 3);
        this.searchBar.setResponder(this::onSearchChanged);
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        this.backButton = new NuggetImageButton(this.screenLeft + 6, this.screenTop + 6, DocAssets.ARROW_BACK_HOVER.width(), DocAssets.ARROW_BACK_HOVER.height(), DocAssets.ARROW_BACK.location(), DocAssets.ARROW_BACK_HOVER.location(), b -> {
            if (this.isShiftDown()) {
                IndexScreen home = new IndexScreen();
                this.transition(home);
                home.previousScreen = null;
                home.backButton.visible = false;
            } else {
                this.goBack();
            }
        }).withTooltip((Component)Component.translatable((String)"ars_nouveau.shift_back"));
        this.addRenderableWidget((GuiEventListener)this.backButton);
        int nextPageYOffset = this.screenBottom - 20;
        this.rightArrow = new NuggetImageButton(this.screenRight - DocAssets.ARROW_RIGHT.width() - 1, nextPageYOffset, DocAssets.ARROW_RIGHT.width(), DocAssets.ARROW_RIGHT.height(), DocAssets.ARROW_RIGHT.location(), DocAssets.ARROW_RIGHT_HOVER.location(), this::onRightArrowClick);
        this.leftArrow = new NuggetImageButton(this.screenLeft + 1, nextPageYOffset, DocAssets.ARROW_RIGHT.width(), DocAssets.ARROW_RIGHT.height(), DocAssets.ARROW_LEFT.location(), DocAssets.ARROW_LEFT_HOVER.location(), this::onLeftArrowClick);
        this.addRenderableWidget((GuiEventListener)this.leftArrow);
        this.addRenderableWidget((GuiEventListener)this.rightArrow);
        if (!this.showLeftArrow()) {
            this.leftArrow.visible = false;
        }
        if (!this.showRightArrow()) {
            this.rightArrow.visible = false;
        }
        this.addRenderableWidget((GuiEventListener)new NuggetImageButton(this.screenLeft - 15, this.screenTop + 140, 0, 0, 23, 20, 23, 20, ArsNouveau.prefix("textures/gui/discord_tab.png"), b -> {
            try {
                Util.getPlatform().openUri(new URI("https://discord.com/invite/y7TMXZu"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.discord")));
        if (this.previousScreen == null && !(this instanceof IndexScreen)) {
            this.previousScreen = new IndexScreen();
        }
        this.backButton.visible = this.previousScreen != null;
        this.initBookmarks();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
    }

    public void onSearchChanged(String str) {
        if (str.equals(this.previousString)) {
            return;
        }
        this.previousString = str;
        if (!str.isEmpty()) {
            this.transition(new SearchScreen(str));
        }
    }

    public boolean isShiftDown() {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)Minecraft.getInstance().options.keyShift.getKey().getValue());
    }

    public void initBookmarks() {
        for (AbstractWidget button : this.bookmarkButtons) {
            this.removeWidget((GuiEventListener)button);
        }
        this.bookmarkButtons.clear();
        List<ResourceLocation> bookmarks = DocPlayerData.bookmarks;
        for (int i = 0; i < bookmarks.size(); ++i) {
            ResourceLocation entryId = bookmarks.get(i);
            DocEntry entry = DocumentationRegistry.getEntry(entryId);
            BookmarkButton slot = (BookmarkButton)this.addRenderableWidget((GuiEventListener)new BookmarkButton(this.screenLeft + 281, this.screenTop + 1 + 15 * (i + 1), entry, b -> {
                if (entry == null) {
                    return;
                }
                boolean isShiftDown = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)Minecraft.getInstance().options.keyShift.getKey().getValue());
                if (isShiftDown) {
                    bookmarks.remove(entryId);
                    this.initBookmarks();
                } else {
                    PageHolderScreen pageHolderScreen = new PageHolderScreen(entry);
                    Screen patt0$temp = Minecraft.getInstance().screen;
                    if (patt0$temp instanceof PageHolderScreen) {
                        PageHolderScreen newPageHolder = (PageHolderScreen)patt0$temp;
                        if (newPageHolder.entry == entry) {
                            return;
                        }
                    }
                    this.transition(pageHolderScreen);
                }
            }));
            this.bookmarkButtons.add((AbstractWidget)slot);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY < 0.0 && this.rightArrow.visible) {
            this.onRightArrowClick((Button)this.rightArrow);
            this.manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        } else if (scrollY > 0.0 && this.leftArrow.visible) {
            this.onLeftArrowClick((Button)this.leftArrow);
            this.manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.searchBar.isHovered() && button == 1) {
            this.goBack();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean charTyped(char c, int i) {
        if (!this.searchBar.isFocused()) {
            this.searchBar.setFocused(true);
        }
        if (this.searchBar.charTyped(c, i)) {
            return true;
        }
        return super.charTyped(c, i);
    }

    public void transition(BaseDocScreen screen) {
        SoundManager manager = Minecraft.getInstance().getSoundManager();
        screen.previousScreen = this;
        manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        Minecraft.getInstance().setScreen((Screen)screen);
    }

    public void goBack() {
        if (this.previousScreen != null) {
            Minecraft.getInstance().setScreen((Screen)this.previousScreen);
            this.manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        }
    }

    public void onClose() {
        super.onClose();
        DocPlayerData.previousScreen = this;
    }

    public boolean showLeftArrow() {
        return this.arrowIndex > 0;
    }

    public boolean showRightArrow() {
        return this.arrowIndex < this.maxArrowIndex;
    }

    public void onLeftArrowClick(Button button) {
        --this.arrowIndex;
        this.onArrowIndexChange();
    }

    public void onRightArrowClick(Button button) {
        ++this.arrowIndex;
        this.onArrowIndexChange();
    }

    public void onArrowIndexChange() {
        this.leftArrow.visible = this.showLeftArrow();
        this.rightArrow.visible = this.showRightArrow();
    }

    public RecipeManager recipeManager() {
        Level level = ArsNouveau.proxy.getClientWorld();
        return level.getRecipeManager();
    }

    public void setMinecraft(Minecraft minecraft) {
        this.minecraft = minecraft;
    }
}

