/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.item.inv;

import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.InteractResult;
import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.MultiExtractedReference;
import com.hollingsworth.arsnouveau.api.item.inv.MultiInsertReference;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.util.InvUtil;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class InventoryManager {
    private static final Random random = new Random();
    public List<FilterableItemHandler> filterables;
    private int extractSlotMax = -1;
    private int insertSlotMax = -1;

    public InventoryManager() {
        this(new ArrayList<FilterableItemHandler>());
    }

    public InventoryManager(List<FilterableItemHandler> filterables) {
        this.filterables = filterables;
    }

    public InventoryManager(IWrappedCaster wrappedCaster) {
        this(wrappedCaster.getInventory());
    }

    public static InventoryManager fromTile(BlockEntity blockEntity) {
        return new InventoryManager(InvUtil.adjacentInventories(blockEntity.getLevel(), blockEntity.getBlockPos()));
    }

    public InventoryManager extractSlotMax(int slotMax) {
        this.extractSlotMax = slotMax;
        return this;
    }

    public InventoryManager insertSlotMax(int slotMax) {
        this.insertSlotMax = slotMax;
        return this;
    }

    public List<FilterableItemHandler> getInventory() {
        return this.filterables;
    }

    public void insertOrDrop(ItemStack stack, Level level, BlockPos pos) {
        ItemStack remainder = this.insertStack(stack);
        if (!remainder.isEmpty()) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), remainder.copy()));
            remainder.setCount(0);
        }
    }

    public ItemStack insertStack(ItemStack stack) {
        return this.insertStackWithReference(stack).getRemainder();
    }

    public MultiInsertReference insertStackWithReference(ItemStack stack) {
        ArrayList<SlotReference> references = new ArrayList<SlotReference>();
        for (FilterablePreference filterPref : this.preferredForStack(stack, false)) {
            FilterableItemHandler filterable = filterPref.handler;
            int count = stack.getCount();
            if (count != (stack = filterable.insertItemStacked(stack, false)).getCount()) {
                references.add(new SlotReference(filterable.getHandler(), filterable.getHandler().getSlots()));
            }
            if (!stack.isEmpty()) continue;
            break;
        }
        return new MultiInsertReference(stack, (List<SlotReference>)references);
    }

    public ExtractedStack extractItem(Predicate<ItemStack> predicate, int count) {
        FilterableItemHandler highestHandler = this.highestPrefInventory(this.getInventory(), predicate, InteractType.EXTRACT);
        return highestHandler == null ? ExtractedStack.empty() : this.extractItem(highestHandler, predicate, count);
    }

    public ExtractedStack extractItem(FilterableItemHandler filteredHandler, Predicate<ItemStack> stackPredicate, int count) {
        SlotReference slotRef = this.findItem(filteredHandler, stackPredicate, InteractType.EXTRACT);
        return slotRef.isEmpty() ? ExtractedStack.empty() : ExtractedStack.from(slotRef, count);
    }

    public ExtractedStack extractRandomItem(Predicate<ItemStack> predicate, int count) {
        FilterableItemHandler highestHandler = this.highestPrefInventory(this.getInventory(), predicate, InteractType.EXTRACT);
        return highestHandler == null ? ExtractedStack.empty() : this.extractRandomItem(highestHandler, predicate, count);
    }

    public ExtractedStack extractRandomItem(FilterableItemHandler filteredHandler, Predicate<ItemStack> stackPredicate, int count) {
        SlotReference slotRef = this.findItemR(filteredHandler, stackPredicate, InteractType.EXTRACT);
        return slotRef.isEmpty() ? ExtractedStack.empty() : ExtractedStack.from(slotRef, count);
    }

    public MultiExtractedReference extractAllFromHandler(FilterableItemHandler filterableItemHandler, ItemStack desiredStack, int count) {
        ItemStack merged = ItemStack.EMPTY;
        int remaining = Math.min(desiredStack.getMaxStackSize(), count);
        ArrayList<ExtractedStack> extractedStacks = new ArrayList<ExtractedStack>();
        IItemHandler itemHandler = filterableItemHandler.getHandler();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.extractItem(i, remaining, true);
            if (stack.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)desiredStack) || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)desiredStack)) continue;
            int toExtract = Math.min(stack.getCount(), remaining);
            remaining -= toExtract;
            if (merged.isEmpty()) {
                merged = stack.copy();
                merged.setCount(toExtract);
            } else {
                merged.grow(toExtract);
            }
            extractedStacks.add(ExtractedStack.from(filterableItemHandler.getHandler(), i, toExtract));
            if (remaining <= 0) break;
        }
        return new MultiExtractedReference(merged, (List<ExtractedStack>)extractedStacks);
    }

    public MultiExtractedReference extractItemFromAll(ItemStack desiredStack, int count, boolean includeInvalidInvs) {
        ItemStack merged = ItemStack.EMPTY;
        int remaining = count;
        Collection<FilterablePreference> preferred = this.preferredForStack(desiredStack, includeInvalidInvs);
        ArrayList<ExtractedStack> extracted = new ArrayList<ExtractedStack>();
        for (FilterablePreference filterPref : preferred) {
            FilterableItemHandler filterable = filterPref.handler;
            if (remaining <= 0) break;
            MultiExtractedReference extractedFromHandler = this.extractAllFromHandler(filterable, desiredStack, remaining);
            if (extractedFromHandler.isEmpty()) continue;
            remaining -= extractedFromHandler.extracted.getCount();
            if (merged.isEmpty()) {
                merged = extractedFromHandler.extracted;
            } else {
                merged.grow(extractedFromHandler.extracted.getCount());
            }
            extracted.addAll(extractedFromHandler.slots);
        }
        return new MultiExtractedReference(merged, (List<ExtractedStack>)extracted);
    }

    public SlotReference findItem(Predicate<ItemStack> predicate, InteractType type) {
        FilterableItemHandler highestHandler = this.highestPrefInventory(this.getInventory(), predicate, type);
        if (highestHandler == null) {
            return SlotReference.empty();
        }
        return this.findItem(highestHandler, predicate, type);
    }

    public SlotReference findItem(FilterableItemHandler itemHandler, Predicate<ItemStack> stackPredicate, InteractType type) {
        for (int slot = 0; slot < this.maxSlotForType(itemHandler, type); ++slot) {
            ItemStack stackInSlot = itemHandler.getHandler().getStackInSlot(slot);
            if (stackInSlot.isEmpty() || !stackPredicate.test(stackInSlot) || !itemHandler.canInteractFor(stackInSlot, type).valid()) continue;
            return new SlotReference(itemHandler.getHandler(), slot);
        }
        return SlotReference.empty();
    }

    public SlotReference findItemR(FilterableItemHandler itemHandler, Predicate<ItemStack> stackPredicate, InteractType type) {
        ArrayList<Integer> validSlots = new ArrayList<Integer>();
        for (int slot = 0; slot < this.maxSlotForType(itemHandler, type); ++slot) {
            ItemStack stackInSlot = itemHandler.getHandler().getStackInSlot(slot);
            if (stackInSlot.isEmpty() || !stackPredicate.test(stackInSlot) || !itemHandler.canInteractFor(stackInSlot, type).valid()) continue;
            validSlots.add(slot);
        }
        if (validSlots.isEmpty()) {
            return SlotReference.empty();
        }
        return new SlotReference(itemHandler.getHandler(), (Integer)validSlots.get(random.nextInt(validSlots.size())));
    }

    public Collection<FilterablePreference> preferredForStack(ItemStack stack, boolean includeInvalid) {
        PriorityQueue<FilterablePreference> filtered = new PriorityQueue<FilterablePreference>((o1, o2) -> {
            ItemScroll.SortPref pref1 = o1.pref();
            ItemScroll.SortPref pref2 = o2.pref();
            return pref2.ordinal() - pref1.ordinal();
        });
        for (FilterableItemHandler filterableItemHandler : this.getInventory()) {
            ItemScroll.SortPref sortPref = filterableItemHandler.getHighestPreference(stack);
            if (!includeInvalid && sortPref == ItemScroll.SortPref.INVALID) continue;
            filtered.add(new FilterablePreference(filterableItemHandler, sortPref));
        }
        return filtered;
    }

    public FilterableItemHandler highestPrefInventory(List<FilterableItemHandler> inventories, Predicate<ItemStack> predicate, InteractType type) {
        ItemScroll.SortPref highestPref = ItemScroll.SortPref.INVALID;
        FilterableItemHandler highestHandler = null;
        for (FilterableItemHandler wrapper : inventories) {
            ItemScroll.SortPref pref = ItemScroll.SortPref.LOW;
            for (int i = 0; i < this.maxSlotForType(wrapper, type); ++i) {
                ItemStack stack = wrapper.getHandler().extractItem(i, 1, true);
                if (stack.isEmpty() || !predicate.test(stack)) continue;
                InteractResult result = wrapper.canInteractFor(stack, type);
                ItemScroll.SortPref foundPref = result.sortPref();
                if (!result.valid()) continue;
                if (foundPref.ordinal() > pref.ordinal()) {
                    pref = foundPref;
                }
                if (pref != ItemScroll.SortPref.HIGHEST) continue;
                return wrapper;
            }
            if (pref.ordinal() <= highestPref.ordinal()) continue;
            highestHandler = wrapper;
            highestPref = pref;
        }
        return highestHandler;
    }

    private int maxSlotForType(FilterableItemHandler filterableItemHandler, InteractType interactType) {
        if (interactType == InteractType.EXTRACT) {
            return this.getExtractSlotMax(filterableItemHandler);
        }
        return this.getInsertSlotMax(filterableItemHandler);
    }

    private int getExtractSlotMax(FilterableItemHandler handler) {
        if (this.extractSlotMax == -1) {
            return handler.getHandler().getSlots();
        }
        return Math.min(this.extractSlotMax, handler.getHandler().getSlots());
    }

    private int getInsertSlotMax(FilterableItemHandler handler) {
        if (this.insertSlotMax == -1) {
            return handler.getHandler().getSlots();
        }
        return Math.min(this.insertSlotMax, handler.getHandler().getSlots());
    }

    public record FilterablePreference(FilterableItemHandler handler, ItemScroll.SortPref pref) {
    }
}

