/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.common.items.foci;

import alexthw.ars_elemental.client.TooltipUtils;
import alexthw.ars_elemental.common.items.foci.GreaterElementalFocus;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.List;
import lyrellion.ars_elemancy.ConfigHandler;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class ElemancyFocus
extends GreaterElementalFocus {
    public ElemancyFocus(Item.Properties properties, SpellSchool element) {
        super(properties, element);
    }

    public double getDiscount() {
        return (Double)ConfigHandler.COMMON.MajorFocusDiscount.get();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block5: {
            block4: {
                LivingEntity livingEntity;
                if (slotContext.entity().level().isClientSide() || !((livingEntity = slotContext.entity()) instanceof Player)) break block4;
                player = (Player)livingEntity;
                if (((Boolean)ConfigHandler.COMMON.EnableRegenBonus.get()).booleanValue()) break block5;
            }
            return;
        }
        if (player.tickCount % 20 == 0) {
            this.applyEnvironmentalEffects(player, this.getSchool());
        }
    }

    public void applyEnvironmentalEffects(Player player, SpellSchool school) {
        switch (school.getId()) {
            case "fire": {
                if (!player.isOnFire() && !player.isInLava()) break;
                player.addEffect(new MobEffectInstance((Holder)ModPotions.SPELL_DAMAGE_EFFECT, 200, 1));
                break;
            }
            case "water": {
                if (!player.isInWaterRainOrBubble()) break;
                if (player.isSwimming()) {
                    player.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 200, 1));
                    player.addEffect(new MobEffectInstance((Holder)ModPotions.MANA_REGEN_EFFECT, 120, 1));
                    break;
                }
                player.addEffect(new MobEffectInstance((Holder)ModPotions.MANA_REGEN_EFFECT, 120, 0));
                break;
            }
            case "air": {
                if (player.hasEffect((Holder)ModPotions.SHOCKED_EFFECT)) {
                    player.addEffect(new MobEffectInstance((Holder)ModPotions.MANA_REGEN_EFFECT, 60, 1));
                    player.addEffect(new MobEffectInstance((Holder)ModPotions.SPELL_DAMAGE_EFFECT, 60, 1));
                    break;
                }
                if (!(player.getY() > 200.0)) break;
                player.addEffect(new MobEffectInstance((Holder)ModPotions.MANA_REGEN_EFFECT, 120, 0));
                break;
            }
            case "earth": {
                if (!(player.getY() < 0.0)) break;
                player.addEffect(new MobEffectInstance((Holder)ModPotions.MANA_REGEN_EFFECT, 120, 0));
            }
        }
        for (SpellSchool sub : school.getSubSchools()) {
            this.applyEnvironmentalEffects(player, sub);
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation uuid, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slotContext, uuid, stack);
        for (SpellSchool sub : this.getSchool().getSubSchools()) {
            if (!sub.equals(SpellSchools.ELEMENTAL_EARTH)) continue;
            map.put((Object)Attributes.KNOCKBACK_RESISTANCE, (Object)new AttributeModifier(uuid, (double)0.2f, AttributeModifier.Operation.ADD_VALUE));
        }
        return map;
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext context, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.ars_elemental.focus_element"));
        TooltipUtils.addOnShift(pTooltipComponents, () -> {
            pTooltipComponents.add((Component)Component.translatable((String)("tooltip.ars_elemancy.focus_boost." + this.element.getId())));
            for (SpellSchool sub : this.getSchool().getSubSchools()) {
                pTooltipComponents.add((Component)Component.translatable((String)("tooltip.ars_elemental.focus_element_mana." + sub.getId())));
            }
        }, (String)"focus");
    }
}

