/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import lyrellion.ars_elemancy.ArsElemancy;
import lyrellion.ars_elemancy.api.item.ISchoolFocus;
import lyrellion.ars_elemancy.util.ParticleUtil;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class SpellFocusRenderer
implements ICurioRenderer {
    final List<String> schools = List.of("fire", "air", "water", "earth");

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Item item = stack.getItem();
        if (item instanceof ISchoolFocus) {
            ISchoolFocus focus = (ISchoolFocus)item;
            item = slotContext.entity();
            if (item instanceof Player) {
                Player player = (Player)item;
                if (player.getUUID().equals(ArsElemancy.Dev)) {
                    this.specialRender(player, ageInTicks);
                } else {
                    double XRot = this.getRelativeAngleX(player, 0.5, 0.0f);
                    double ZRot = this.getRelativeAngleZ(player, 0.5, 0.0f);
                    new ParticleUtil.ParticleBuilder(ParticleUtil.schoolToColor(focus.getSchool().getId())).scale(0.16666667f).alpha(0.4f).spawn(player.level(), XRot, player.getEyeY() + 0.2 + 0.05 * Math.sin(ageInTicks / 10.0f), ZRot);
                    new ParticleUtil.ParticleBuilder(ParticleUtil.schoolToColor2(focus.getSchool().getId())).scale(0.125f).alpha(0.2f).setLifetime(10).spawn(player.level(), XRot, player.getEyeY() + 0.2 + 0.05 * Math.sin(ageInTicks / 10.0f), ZRot);
                }
            }
        }
    }

    public void specialRender(Player player, float ageInTicks) {
        int i = 0;
        for (String school : this.schools) {
            double bob = 0.05 * Math.sin(ageInTicks / 10.0f);
            new ParticleUtil.ParticleBuilder(ParticleUtil.schoolToColor(school)).scale(0.16666667f).alpha(0.6f).spawn(player.level, this.getRelativeAngleX(player, (double)i * 0.5, ageInTicks), player.getEyeY() + 0.2 + bob, this.getRelativeAngleZ(player, (double)i * 0.5, ageInTicks));
            new ParticleUtil.ParticleBuilder(ParticleUtil.schoolToColor2(school)).scale(0.125f).alpha(0.4f).setLifetime(10).spawn(player.level, this.getRelativeAngleX(player, (double)i * 0.5, ageInTicks), player.getEyeY() + 0.2 + bob, this.getRelativeAngleZ(player, (double)i * 0.5, ageInTicks));
            ++i;
        }
    }

    public double getRelativeAngleX(Player player, double rad, float spin) {
        return player.getX() + Math.sin(this.getRadians(player, rad, spin)) / 1.5;
    }

    public double getRelativeAngleZ(Player player, double rad, float spin) {
        return player.getZ() - Math.cos(this.getRadians(player, rad, spin)) / 1.5;
    }

    private double getRadians(Player player, double rad, float spin) {
        return Math.toRadians((double)player.yBodyRot + rad * 180.0 + (double)spin);
    }
}

