/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.network.packet;

import com.sts15.enderdrives.client.ClientConfigCache;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncConfigPacket(int freqMin, int freqMax) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncConfigPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)"sync_config"));
    public static final StreamCodec<FriendlyByteBuf, SyncConfigPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncConfigPacket::freqMin, (StreamCodec)ByteBufCodecs.VAR_INT, SyncConfigPacket::freqMax, SyncConfigPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncConfigPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientConfigCache.update(packet.freqMin, packet.freqMax));
    }
}

