/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.network.packet;

import com.sts15.enderdrives.db.TapeDBManager;
import com.sts15.enderdrives.network.packet.UpdateTapeTypeCountPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RequestTapeTypeCountPacket(long mostSigBits, long leastSigBits) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestTapeTypeCountPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)"request_tape_type_count"));
    public static final StreamCodec<FriendlyByteBuf, RequestTapeTypeCountPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, RequestTapeTypeCountPacket::mostSigBits, (StreamCodec)ByteBufCodecs.VAR_LONG, RequestTapeTypeCountPacket::leastSigBits, RequestTapeTypeCountPacket::new);

    public static void handle(RequestTapeTypeCountPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            UUID id = new UUID(packet.mostSigBits(), packet.leastSigBits());
            int typeCount = TapeDBManager.getTypeCount(id);
            long byteCount = TapeDBManager.getTotalStoredBytes(id);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)context.player()), (CustomPacketPayload)new UpdateTapeTypeCountPacket(id, typeCount, byteCount), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

