/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.Message;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.awt.Color;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class MidnightConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?(\\d+\\.?\\d*|\\d*\\.?\\d+|\\.)");
    private static final Pattern HEXADECIMAL_ONLY = Pattern.compile("(-?[#0-9a-fA-F]*)");
    private static final List<EntryInfo> entries = new ArrayList<EntryInfo>();
    public static final Map<String, Class<? extends MidnightConfig>> configClass = new HashMap<String, Class<? extends MidnightConfig>>();
    private static Path path;
    private static final Gson gson;

    @Nullable
    public static Object getDefaultValue(String modid, String entry) {
        for (EntryInfo e : entries) {
            if (!modid.equals(e.modid) || !entry.equals(e.field.getName())) continue;
            return e.defaultValue;
        }
        return null;
    }

    public static void init(String modid, Class<? extends MidnightConfig> config) {
        path = PlatformFunctions.getConfigDirectory().resolve(modid + ".json");
        configClass.put(modid, config);
        for (Field field : config.getFields()) {
            EntryInfo info = new EntryInfo();
            if ((field.isAnnotationPresent(Entry.class) || field.isAnnotationPresent(Comment.class)) && !field.isAnnotationPresent(Server.class) && !field.isAnnotationPresent(Hidden.class) && PlatformFunctions.isClientEnv()) {
                MidnightConfig.initClient(modid, field, info);
            }
            if (!field.isAnnotationPresent(Entry.class)) continue;
            try {
                info.defaultValue = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        try {
            gson.fromJson((Reader)Files.newBufferedReader(path), config);
        }
        catch (Exception e) {
            MidnightConfig.write(modid);
        }
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(Entry.class)) continue;
            try {
                info.value = info.field.get(null);
                info.tempValue = info.toTemporaryValue();
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void initClient(String modid, Field field, EntryInfo info) {
        info.dataType = MidnightConfig.getUnderlyingType(field);
        Entry e = field.getAnnotation(Entry.class);
        Comment c = field.getAnnotation(Comment.class);
        info.width = e != null ? e.width() : 0;
        info.field = field;
        info.modid = modid;
        boolean requiredModLoaded = true;
        if (e != null) {
            if (!e.requiredMod().isEmpty()) {
                requiredModLoaded = PlatformFunctions.isModLoaded(e.requiredMod());
            }
            if (!requiredModLoaded) {
                return;
            }
            if (!e.name().isEmpty()) {
                info.name = Component.translatable((String)e.name());
            }
            if (info.dataType == Integer.TYPE) {
                MidnightConfig.textField(info, Integer::parseInt, INTEGER_ONLY, (int)e.min(), (int)e.max(), true);
            } else if (info.dataType == Float.TYPE) {
                MidnightConfig.textField(info, Float::parseFloat, DECIMAL_ONLY, (float)e.min(), (float)e.max(), false);
            } else if (info.dataType == Double.TYPE) {
                MidnightConfig.textField(info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (info.dataType == String.class || info.dataType == ResourceLocation.class) {
                MidnightConfig.textField(info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (info.dataType == Boolean.TYPE) {
                Function<Object, Component> func = value -> Component.translatable((String)((Boolean)value != false ? "gui.yes" : "gui.no")).withStyle((Boolean)value != false ? ChatFormatting.GREEN : ChatFormatting.RED);
                info.function = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    info.setValue((Boolean)info.value == false);
                    button.setMessage((Component)func.apply(info.value));
                }, func);
            } else if (info.dataType.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, Component> func = value -> {
                    String translationKey = modid + ".midnightconfig.enum." + info.dataType.getSimpleName() + "." + info.toTemporaryValue();
                    return I18n.exists((String)translationKey) ? Component.translatable((String)translationKey) : Component.literal((String)info.toTemporaryValue());
                };
                info.function = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.setMessage((Component)func.apply(info.value));
                }, func);
            }
        } else if (c != null) {
            if (!c.requiredMod().isEmpty()) {
                requiredModLoaded = PlatformFunctions.isModLoaded(c.requiredMod());
            }
            info.centered = c.centered();
        }
        if (requiredModLoaded) {
            entries.add(info);
        }
    }

    public static Class<?> getUnderlyingType(Field field) {
        Class rawType = field.getType();
        if (field.getType() == List.class) {
            rawType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        }
        try {
            return (Class)rawType.getField("TYPE").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            return rawType;
        }
    }

    public static Tooltip getTooltip(EntryInfo info, boolean isButton) {
        String key = info.modid + ".midnightconfig." + info.field.getName() + (!isButton ? ".label" : "") + ".tooltip";
        return Tooltip.create((Component)(isButton && info.error != null ? info.error : (I18n.exists((String)key) ? Component.translatable((String)key) : Component.empty())));
    }

    private static void textField(EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.function = (t, b) -> s -> {
            if (!((String)(s = ((String)s).trim())).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (!(isNumber && ((String)s).isEmpty() || ((String)s).equals("-") || ((String)s).equals("."))) {
                try {
                    value = (Number)f.apply((String)s);
                }
                catch (NumberFormatException e2) {
                    return false;
                }
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : Component.literal((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max))).withStyle(ChatFormatting.RED);
                t.setTooltip(MidnightConfig.getTooltip(info, true));
            }
            info.tempValue = s;
            t.setTextColor(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.active = entries.stream().allMatch(e -> e.inLimits);
            if (inLimits) {
                if (info.dataType == ResourceLocation.class) {
                    info.setValue(ResourceLocation.tryParse((String)s));
                } else {
                    info.setValue(isNumber ? value : s);
                }
            }
            if (info.field.getAnnotation(Entry.class).isColor()) {
                if (!((String)s).contains("#")) {
                    s = "#" + (String)s;
                }
                if (!HEXADECIMAL_ONLY.matcher((CharSequence)s).matches()) {
                    return false;
                }
                try {
                    info.actionButton.setMessage((Component)Component.literal((String)"\u2b1b").setStyle(Style.EMPTY.withColor(Color.decode(info.tempValue).getRGB())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    public static MidnightConfig getClass(String modid) {
        try {
            return configClass.get(modid).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(String modid) {
        MidnightConfig.getClass(modid).writeChanges(modid);
    }

    public void writeChanges(String modid) {
        try {
            path = PlatformFunctions.getConfigDirectory().resolve(modid + ".json");
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, gson.toJson((Object)MidnightConfig.getClass(modid)).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static Screen getScreen(Screen parent, String modid) {
        return new MidnightConfigScreen(parent, modid);
    }

    static {
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).addSerializationExclusionStrategy((ExclusionStrategy)new HiddenAnnotationExclusionStrategy()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().create();
    }

    public static class EntryInfo {
        Field field;
        Class<?> dataType;
        int width;
        int listIndex;
        boolean centered;
        Object defaultValue;
        Object value;
        Object function;
        String modid;
        String tempValue;
        boolean inLimits = true;
        Component name;
        Component error;
        AbstractWidget actionButton;
        Tab tab;

        public void setValue(Object value) {
            if (this.field.getType() != List.class) {
                this.value = value;
                this.tempValue = value.toString();
            } else {
                this.writeList(this.listIndex, value);
                this.tempValue = this.toTemporaryValue();
            }
        }

        public String toTemporaryValue() {
            if (this.field.getType() != List.class) {
                return this.value.toString();
            }
            try {
                return ((List)this.value).get(this.listIndex).toString();
            }
            catch (Exception ignored) {
                return "";
            }
        }

        public <T> void writeList(int index, T value) {
            List list = (List)this.value;
            if (index >= list.size()) {
                list.add(value);
            } else {
                list.set(index, value);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public int width() default 400;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;

        public String name() default "";

        public int selectionMode() default -1;

        public int fileChooserType() default 0;

        public String[] fileExtensions() default {"*"};

        public int idMode() default -1;

        public boolean isColor() default false;

        public boolean isSlider() default false;

        public int precision() default 100;

        public String category() default "default";

        public String requiredMod() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Comment {
        public boolean centered() default false;

        public String category() default "default";

        public String requiredMod() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Server {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    @Environment(value=EnvType.CLIENT)
    public static class MidnightConfigScreen
    extends Screen {
        public final String translationPrefix;
        public final String modid;
        public final Screen parent;
        public MidnightConfigListWidget list;
        public TabManager tabManager = new TabManager(a -> {}, a -> {});
        public Map<String, Tab> tabs = new LinkedHashMap<String, Tab>();
        public Tab prevTab;
        public TabNavigationBar tabNavigation;
        public Button done;
        public double scrollProgress = 0.0;

        protected MidnightConfigScreen(Screen parent, String modid) {
            super((Component)Component.translatable((String)(modid + ".midnightconfig.title")));
            this.parent = parent;
            this.modid = modid;
            this.translationPrefix = modid + ".midnightconfig.";
            this.loadValues();
            for (EntryInfo e : entries) {
                if (!e.modid.equals(modid)) continue;
                String tabId = e.field.isAnnotationPresent(Entry.class) ? e.field.getAnnotation(Entry.class).category() : e.field.getAnnotation(Comment.class).category();
                String name = this.translationPrefix + "category." + tabId;
                if (!I18n.exists((String)name) && tabId.equals("default")) {
                    name = this.translationPrefix + "title";
                }
                if (!this.tabs.containsKey(name)) {
                    GridLayoutTab tab = new GridLayoutTab((Component)Component.translatable((String)name));
                    e.tab = tab;
                    this.tabs.put(name, (Tab)tab);
                    continue;
                }
                e.tab = this.tabs.get(name);
            }
            this.tabNavigation = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width).addTabs(this.tabs.values().toArray(new Tab[0])).build();
            this.tabNavigation.selectTab(0, false);
            this.tabNavigation.arrangeElements();
            this.prevTab = this.tabManager.getCurrentTab();
        }

        public void tick() {
            super.tick();
            if (this.prevTab != null && this.prevTab != this.tabManager.getCurrentTab()) {
                this.prevTab = this.tabManager.getCurrentTab();
                this.list.clear();
                this.fillList();
                this.list.setScrollAmount(0.0);
            }
            this.scrollProgress = this.list.getScrollAmount();
            for (EntryInfo info : entries) {
                try {
                    info.field.set(null, info.value);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            this.updateButtons();
        }

        public void updateButtons() {
            if (this.list != null) {
                for (ButtonEntry entry : this.list.children()) {
                    AbstractWidget widget;
                    if (entry.buttons == null || entry.buttons.size() <= 1) continue;
                    AbstractWidget abstractWidget = entry.buttons.get(0);
                    if (abstractWidget instanceof AbstractWidget && ((widget = abstractWidget).isFocused() || widget.isHovered())) {
                        widget.setTooltip(MidnightConfig.getTooltip(entry.info, true));
                    }
                    if (!((abstractWidget = entry.buttons.get(1)) instanceof Button)) continue;
                    Button button = (Button)abstractWidget;
                    button.active = !Objects.equals(entry.info.value.toString(), entry.info.defaultValue.toString());
                }
            }
        }

        public void loadValues() {
            try {
                gson.fromJson((Reader)Files.newBufferedReader(path), configClass.get(this.modid));
            }
            catch (Exception e) {
                MidnightConfig.write(this.modid);
            }
            for (EntryInfo info : entries) {
                if (!info.field.isAnnotationPresent(Entry.class)) continue;
                try {
                    info.value = info.field.get(null);
                    info.tempValue = info.toTemporaryValue();
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (this.tabNavigation.keyPressed(keyCode)) {
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public void onClose() {
            this.loadValues();
            this.cleanup();
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
        }

        private void cleanup() {
            entries.forEach(info -> {
                info.error = null;
                info.value = null;
                info.tempValue = null;
                info.actionButton = null;
                info.listIndex = 0;
                info.tab = null;
                info.inLimits = true;
            });
        }

        public void init() {
            super.init();
            this.tabNavigation.setWidth(this.width);
            this.tabNavigation.arrangeElements();
            if (this.tabs.size() > 1) {
                this.addRenderableWidget((GuiEventListener)this.tabNavigation);
            }
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).bounds(this.width / 2 - 154, this.height - 26, 150, 20).build());
            this.done = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
                for (EntryInfo info : entries) {
                    if (!info.modid.equals(this.modid)) continue;
                    try {
                        info.field.set(null, info.value);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                MidnightConfig.write(this.modid);
                this.cleanup();
                Objects.requireNonNull(this.minecraft).setScreen(this.parent);
            }).bounds(this.width / 2 + 4, this.height - 26, 150, 20).build());
            this.list = new MidnightConfigListWidget(this.minecraft, this.width, this.height - 57, 24, 25);
            this.addWidget((GuiEventListener)this.list);
            this.fillList();
            if (this.tabs.size() > 1) {
                this.list.renderHeaderSeparator = false;
            }
        }

        public void fillList() {
            for (EntryInfo info : entries) {
                if (info.modid.equals(this.modid) && (info.tab == null || info.tab == this.tabManager.getCurrentTab())) {
                    Component name = Objects.requireNonNullElseGet(info.name, () -> Component.translatable((String)(this.translationPrefix + info.field.getName())));
                    SpriteIconButton resetButton = SpriteIconButton.builder((Component)Component.translatable((String)"controls.reset"), button -> {
                        info.value = info.defaultValue;
                        info.listIndex = 0;
                        info.tempValue = info.toTemporaryValue();
                        this.list.clear();
                        this.fillList();
                    }, (boolean)true).sprite(ResourceLocation.fromNamespaceAndPath((String)"midnightlib", (String)"icon/reset"), 12, 12).size(20, 20).build();
                    resetButton.setPosition(this.width - 205 + 150 + 25, 0);
                    if (info.function != null) {
                        Object widget;
                        Entry e = info.field.getAnnotation(Entry.class);
                        if (info.function instanceof Map.Entry) {
                            Map.Entry values = (Map.Entry)info.function;
                            if (info.dataType.isEnum()) {
                                values.setValue(value -> Component.translatable((String)(this.translationPrefix + "enum." + info.field.getType().getSimpleName() + "." + info.value.toString())));
                            }
                            widget = Button.builder((Component)((Component)((Function)values.getValue()).apply(info.value)), (Button.OnPress)((Button.OnPress)values.getKey())).bounds(this.width - 185, 0, 150, 20).tooltip(MidnightConfig.getTooltip(info, true)).build();
                        } else {
                            widget = e.isSlider() ? new MidnightSliderWidget(this.width - 185, 0, 150, 20, Component.nullToEmpty((String)info.tempValue), (Double.parseDouble(info.tempValue) - e.min()) / (e.max() - e.min()), info) : new EditBox(this.font, this.width - 185, 0, 150, 20, (Component)Component.empty());
                        }
                        if (widget instanceof EditBox) {
                            EditBox textField = widget;
                            textField.setMaxLength(info.width);
                            textField.setValue(info.tempValue);
                            Predicate processor = (Predicate)((BiFunction)info.function).apply(textField, this.done);
                            textField.setFilter(processor);
                        }
                        widget.setTooltip(MidnightConfig.getTooltip(info, true));
                        Button cycleButton = null;
                        if (info.field.getType() == List.class) {
                            cycleButton = Button.builder((Component)Component.literal((String)String.valueOf(info.listIndex)).withStyle(ChatFormatting.GOLD), button -> {
                                List values = (List)info.value;
                                values.remove("");
                                ++info.listIndex;
                                if (info.listIndex > values.size()) {
                                    info.listIndex = 0;
                                }
                                info.tempValue = info.toTemporaryValue();
                                if (info.listIndex == values.size()) {
                                    info.tempValue = "";
                                }
                                this.list.clear();
                                this.fillList();
                            }).bounds(this.width - 185, 0, 20, 20).build();
                        }
                        if (e.isColor()) {
                            Button colorButton = Button.builder((Component)Component.literal((String)"\u2b1b"), button -> new Thread(() -> {
                                Color newColor = JColorChooser.showDialog(null, Component.translatable((String)"midnightconfig.colorChooser.title").getString(), Color.decode(!Objects.equals(info.tempValue, "") ? info.tempValue : "#FFFFFF"));
                                if (newColor != null) {
                                    info.setValue("#" + Integer.toHexString(newColor.getRGB()).substring(2));
                                    this.list.clear();
                                    this.fillList();
                                }
                            }).start()).bounds(this.width - 185, 0, 20, 20).build();
                            try {
                                colorButton.setMessage((Component)Component.literal((String)"\u2b1b").setStyle(Style.EMPTY.withColor(Color.decode(info.tempValue).getRGB())));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            info.actionButton = colorButton;
                        } else if (e.selectionMode() > -1) {
                            SpriteIconButton explorerButton = SpriteIconButton.builder((Component)Component.empty(), button -> new Thread(() -> {
                                JFileChooser fileChooser = new JFileChooser(info.tempValue);
                                fileChooser.setFileSelectionMode(e.selectionMode());
                                fileChooser.setDialogType(e.fileChooserType());
                                fileChooser.setDialogTitle(Component.translatable((String)(this.translationPrefix + info.field.getName() + ".fileChooser")).getString());
                                if ((e.selectionMode() == 0 || e.selectionMode() == 2) && Arrays.stream(e.fileExtensions()).noneMatch("*"::equals)) {
                                    fileChooser.setFileFilter(new FileNameExtensionFilter(Component.translatable((String)(this.translationPrefix + info.field.getName() + ".fileFilter")).getString(), e.fileExtensions()));
                                }
                                if (fileChooser.showDialog(null, null) == 0) {
                                    info.setValue(fileChooser.getSelectedFile().getAbsolutePath());
                                    this.list.clear();
                                    this.fillList();
                                }
                            }).start(), (boolean)true).sprite(ResourceLocation.fromNamespaceAndPath((String)"midnightlib", (String)"icon/explorer"), 12, 12).size(20, 20).build();
                            explorerButton.setPosition(this.width - 185, 0);
                            info.actionButton = explorerButton;
                        }
                        ArrayList widgets = Lists.newArrayList((Object[])new AbstractWidget[]{widget, resetButton});
                        if (info.actionButton != null) {
                            if (Minecraft.ON_OSX) {
                                info.actionButton.active = false;
                            }
                            widget.setWidth(widget.getWidth() - 22);
                            widget.setX(widget.getX() + 22);
                            widgets.add(info.actionButton);
                        }
                        if (cycleButton != null) {
                            if (info.actionButton != null) {
                                info.actionButton.setX(info.actionButton.getX() + 22);
                            }
                            widget.setWidth(widget.getWidth() - 22);
                            widget.setX(widget.getX() + 22);
                            widgets.add(cycleButton);
                        }
                        this.list.addButton(widgets, name, info);
                    } else {
                        this.list.addButton(List.of(), name, info);
                    }
                }
                this.list.setScrollAmount(this.scrollProgress);
                this.updateButtons();
            }
        }

        public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
            super.render(context, mouseX, mouseY, delta);
            this.list.render(context, mouseX, mouseY, delta);
            if (this.tabs.size() < 2) {
                context.drawCenteredString(this.font, this.title, this.width / 2, 10, 0xFFFFFF);
            }
            if (this.list != null) {
                for (ButtonEntry entry : this.list.children()) {
                    AbstractWidget abstractWidget;
                    if (entry.buttons == null || entry.buttons.size() <= 1 || !((abstractWidget = entry.buttons.getFirst()) instanceof AbstractWidget)) continue;
                    AbstractWidget widget = abstractWidget;
                    int idMode = entry.info.field.getAnnotation(Entry.class).idMode();
                    if (idMode == -1) continue;
                    context.renderItem(idMode == 0 ? ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)entry.info.tempValue))).getDefaultInstance() : ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)entry.info.tempValue))).asItem().getDefaultInstance(), widget.getX() + widget.getWidth() - 18, widget.getY() + 2);
                }
            }
        }
    }

    public static class HiddenAnnotationExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Entry.class) == null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Client {
    }

    public static class MidnightSliderWidget
    extends AbstractSliderButton {
        private final EntryInfo info;
        private final Entry e;

        public MidnightSliderWidget(int x, int y, int width, int height, Component text, double value, EntryInfo info) {
            super(x, y, width, height, text, value);
            this.e = info.field.getAnnotation(Entry.class);
            this.info = info;
        }

        public void updateMessage() {
            this.setMessage(Component.nullToEmpty((String)this.info.tempValue));
        }

        public void applyValue() {
            if (this.info.dataType == Integer.TYPE) {
                this.info.setValue(((Number)(this.e.min() + this.value * (this.e.max() - this.e.min()))).intValue());
            } else if (this.info.dataType == Double.TYPE) {
                this.info.setValue((double)Math.round((this.e.min() + this.value * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (double)this.e.precision());
            } else if (this.info.dataType == Float.TYPE) {
                this.info.setValue(Float.valueOf((float)Math.round((this.e.min() + this.value * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (float)this.e.precision()));
            }
        }
    }

    public static class ButtonEntry
    extends ContainerObjectSelectionList.Entry<ButtonEntry> {
        private static final Font textRenderer = Minecraft.getInstance().font;
        public final Component text;
        public final List<AbstractWidget> buttons;
        public final EntryInfo info;
        public boolean centered = false;
        public MultiLineTextWidget title;

        public ButtonEntry(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            this.buttons = buttons;
            this.text = text;
            this.info = info;
            if (info != null) {
                this.centered = info.centered;
            }
            int scaledWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            if (!(text == null || text.getString().contains("spacer") && buttons.isEmpty())) {
                this.title = new MultiLineTextWidget(this.centered ? scaledWidth / 2 - textRenderer.width((FormattedText)text) / 2 : 12, 0, Component.translationArg((Message)text), textRenderer);
                if (info != null) {
                    this.title.setTooltip(MidnightConfig.getTooltip(info, false));
                }
                this.title.setMaxWidth(buttons.size() > 1 ? buttons.get(1).getX() - 24 : scaledWidth - 24);
            }
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.buttons.forEach(b -> {
                b.setY(y);
                b.render(context, mouseX, mouseY, tickDelta);
            });
            if (this.title != null) {
                boolean tooltipVisible;
                this.title.setY(y + 9);
                this.title.renderWidget(context, mouseX, mouseY, tickDelta);
                boolean bl = tooltipVisible = mouseX >= this.title.getX() && mouseX < this.title.getWidth() + this.title.getX() && mouseY >= this.title.getY() && mouseY < this.title.getHeight() + this.title.getY();
                if (tooltipVisible && this.title.getTooltip() != null) {
                    context.renderTooltip(textRenderer, this.title.getTooltip().toCharSequence(Minecraft.getInstance()), mouseX, mouseY);
                }
            }
        }

        public List<? extends GuiEventListener> children() {
            return Lists.newArrayList(this.buttons);
        }

        public List<? extends NarratableEntry> narratables() {
            return Lists.newArrayList(this.buttons);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class MidnightConfigListWidget
    extends ContainerObjectSelectionList<ButtonEntry> {
        public boolean renderHeaderSeparator = true;

        public MidnightConfigListWidget(Minecraft client, int width, int height, int y, int itemHeight) {
            super(client, width, height, y, itemHeight);
        }

        public int getScrollbarPosition() {
            return this.width - 7;
        }

        protected void renderListSeparators(GuiGraphics context) {
            if (this.renderHeaderSeparator) {
                super.renderListSeparators(context);
            } else {
                RenderSystem.enableBlend();
                context.blit(this.minecraft.level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR, this.getX(), this.getBottom(), 0.0f, 0.0f, this.getWidth(), 2, 32, 2);
                RenderSystem.disableBlend();
            }
        }

        public void addButton(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            this.addEntry((AbstractSelectionList.Entry)new ButtonEntry(buttons, text, info));
        }

        public void clear() {
            this.clearEntries();
        }

        public int getRowWidth() {
            return 10000;
        }
    }
}

