/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemInterface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class TileEntityLaserRelayItem
extends TileEntityLaserRelay {
    public final Map<BlockPos, SlotlessableItemHandlerWrapper> handlersAround = new ConcurrentHashMap<BlockPos, SlotlessableItemHandlerWrapper>();
    public int priority;

    public TileEntityLaserRelayItem(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, LaserType.ITEM);
    }

    public TileEntityLaserRelayItem(BlockPos pos, BlockState state) {
        this(ActuallyBlocks.LASER_RELAY_ITEM.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLaserRelayItem) {
            TileEntityLaserRelayItem tile = (TileEntityLaserRelayItem)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLaserRelayItem) {
            TileEntityLaserRelayItem tile = (TileEntityLaserRelayItem)t;
            tile.serverTick();
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isWhitelisted(ItemStack stack, boolean output) {
        return true;
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        Network network;
        HashMap<BlockPos, SlotlessableItemHandlerWrapper> old = new HashMap<BlockPos, SlotlessableItemHandlerWrapper>(this.handlersAround);
        boolean change = false;
        this.handlersAround.clear();
        for (int i = 0; i <= 5; ++i) {
            BlockEntity tile;
            Direction side = WorldUtil.getDirectionBySidesInOrder(i);
            BlockPos pos = this.getBlockPos().relative(side);
            if (!this.level.hasChunkAt(pos) || (tile = this.level.getBlockEntity(pos)) == null || tile instanceof TileEntityItemInterface || tile instanceof TileEntityLaserRelay) continue;
            IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), (Object)side.getOpposite());
            Object slotlessHandler = null;
            SlotlessableItemHandlerWrapper handler = new SlotlessableItemHandlerWrapper(itemHandler, slotlessHandler);
            this.handlersAround.put(pos, handler);
            SlotlessableItemHandlerWrapper oldHandler = (SlotlessableItemHandlerWrapper)old.get(pos);
            if (handler.equals(oldHandler)) continue;
            change = true;
        }
        if ((change || old.size() != this.handlersAround.size()) && (network = this.getNetwork()) != null) {
            ++network.changeAmount;
        }
    }

    public void getItemHandlersInNetwork(Network network, List<TileEntityItemInterface.GenericItemHandlerInfo> storeList) {
        HashSet<BlockPos> alreadyChecked = new HashSet<BlockPos>();
        for (IConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.getPositions()) {
                if (relay == null || !this.level.hasChunkAt(relay) || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                BlockEntity aRelayTile = this.level.getBlockEntity(relay);
                if (!(aRelayTile instanceof TileEntityLaserRelayItem)) continue;
                TileEntityLaserRelayItem relayTile = (TileEntityLaserRelayItem)aRelayTile;
                TileEntityItemInterface.GenericItemHandlerInfo info = new TileEntityItemInterface.GenericItemHandlerInfo(relayTile);
                for (Map.Entry<BlockPos, SlotlessableItemHandlerWrapper> handler : relayTile.handlersAround.entrySet()) {
                    if (alreadyChecked.contains(handler.getKey())) continue;
                    alreadyChecked.add(handler.getKey());
                    info.handlers.add(handler.getValue());
                }
                storeList.add(info);
            }
        }
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, lookupProvider, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("Priority", this.priority);
        }
    }

    @Override
    public Component getExtraDisplayString() {
        return Component.translatable((String)"info.actuallyadditions.laserRelay.item.extra").append(": ").append((Component)Component.literal((String)String.valueOf(this.getPriority())).withStyle(ChatFormatting.DARK_RED));
    }

    @Override
    public Component getCompassDisplayString() {
        return Component.translatable((String)"info.actuallyadditions.laserRelay.item.display.1").append(" - ").append((Component)Component.translatable((String)"info.actuallyadditions.laserRelay.item.display.2")).withStyle(ChatFormatting.GREEN);
    }

    @Override
    public void onCompassAction(Player player) {
        this.priority = player.isCrouching() ? --this.priority : ++this.priority;
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, lookupProvider, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.priority = compound.getInt("Priority");
        }
    }
}

