/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.base.AACrops;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ActuallyConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_BLACK_QUARTZ = ActuallyConfiguredFeatures.createKey("ore_black_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CANOLA_PATCH = ActuallyConfiguredFeatures.createKey("canola_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLAX_PATCH = ActuallyConfiguredFeatures.createKey("flax_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COFFEE_PATCH = ActuallyConfiguredFeatures.createKey("coffee_patch");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneRuleTest = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateRuleTest = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> list = List.of(OreConfiguration.target((RuleTest)stoneRuleTest, (BlockState)ActuallyBlocks.BLACK_QUARTZ_ORE.get().defaultBlockState()), OreConfiguration.target((RuleTest)deepslateRuleTest, (BlockState)ActuallyBlocks.BLACK_QUARTZ_ORE.get().defaultBlockState()));
        FeatureUtils.register(context, ORE_BLACK_QUARTZ, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(list, 6));
        FeatureUtils.register(context, CANOLA_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)ActuallyConfiguredFeatures.plantPatch((Block)ActuallyBlocks.CANOLA.get(), 10));
        FeatureUtils.register(context, FLAX_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)ActuallyConfiguredFeatures.plantPatch((Block)ActuallyBlocks.FLAX.get(), 8));
        FeatureUtils.register(context, COFFEE_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)ActuallyConfiguredFeatures.plantPatch((Block)ActuallyBlocks.COFFEE.get(), 6));
    }

    private static RandomPatchConfiguration plantPatch(Block crop, int tries) {
        SimpleStateProvider stateProvider = BlockStateProvider.simple((BlockState)((BlockState)((BlockState)crop.defaultBlockState().setValue((Property)AACrops.AGE, (Comparable)Integer.valueOf(7))).setValue((Property)AACrops.PERSISTENT, (Comparable)Boolean.valueOf(true))));
        return FeatureUtils.simpleRandomPatchConfiguration((int)tries, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)stateProvider)));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ActuallyAdditions.modLoc(name));
    }
}

