/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures.mixin;

import io.github.frqnny.mostructures.util.ItemUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class MixinLivingEntity {
    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="TAIL")})
    public void dropItems(DamageSource source, CallbackInfo info) {
        Rabbit rabbit;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Rabbit && (rabbit = (Rabbit)livingEntity).getVariant() == Rabbit.Variant.EVIL) {
            ItemStack diamonds = new ItemStack((ItemLike)Items.DIAMOND);
            diamonds.setCount(Math.max(8, rabbit.getRandom().nextInt(10)));
            ItemUtils.spawnStack(rabbit.getCommandSenderWorld(), rabbit.getX(), rabbit.getY() + 0.5, rabbit.getZ(), diamonds);
            ItemStack emeralds = new ItemStack((ItemLike)Items.EMERALD);
            emeralds.setCount(Math.max(10, rabbit.getRandom().nextInt(12)));
            ItemUtils.spawnStack(rabbit.getCommandSenderWorld(), rabbit.getX(), rabbit.getY() + 0.5, rabbit.getZ(), emeralds);
            ItemStack ironIngots = new ItemStack((ItemLike)Items.IRON_INGOT);
            ironIngots.setCount(Math.max(18, rabbit.getRandom().nextInt(20)));
            ItemUtils.spawnStack(rabbit.getCommandSenderWorld(), rabbit.getX(), rabbit.getY() + 0.5, rabbit.getZ(), ironIngots);
            ItemStack goldIngots = new ItemStack((ItemLike)Items.IRON_INGOT);
            goldIngots.setCount(Math.max(16, rabbit.getRandom().nextInt(18)));
            ItemUtils.spawnStack(rabbit.getCommandSenderWorld(), rabbit.getX(), rabbit.getY() + 0.5, rabbit.getZ(), goldIngots);
        }
    }
}

