/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

public class TimedCooldown {
    private final long startValue;
    private long expirationMs = 0L;

    public TimedCooldown(long startValue) {
        this.startValue = startValue;
    }

    public long getStartValue() {
        return this.startValue;
    }

    public boolean trySet() {
        if (this.isOnCooldown()) {
            return false;
        }
        this.forceSet();
        return true;
    }

    public void forceSet() {
        this.expirationMs = System.currentTimeMillis() + this.startValue;
    }

    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.expirationMs;
    }

    public void reset() {
        this.expirationMs = 0L;
    }
}

