/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import net.minecraft.world.entity.player.Player;

public class ExperienceUtils {
    public static int getExperienceForLevelAfter(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static int getLevel(int experience) {
        int totalExperienceFor16 = 352;
        int totalExperienceFor31 = 1507;
        if (experience <= totalExperienceFor16) {
            return (int)(Math.sqrt(experience + 9) - 3.0);
        }
        if (experience <= totalExperienceFor31) {
            return (int)(Math.sqrt(0.4f * ((float)experience - 195.975f)) + (double)8.1f);
        }
        return (int)(Math.sqrt(0.22222222f * ((float)experience - 752.9861f)) + 18.05555534362793);
    }

    public static double getLevelAndProgress(int experience) {
        int wholeLevel = ExperienceUtils.getLevel(experience);
        int requiredForNext = ExperienceUtils.getExperienceForLevelAfter(wholeLevel + 1);
        double progress = (double)(experience - ExperienceUtils.getTotalExperience(wholeLevel)) / (double)requiredForNext;
        return (double)wholeLevel + progress;
    }

    public static int getTotalExperience(int targetLevel) {
        if (targetLevel <= 16) {
            return targetLevel * targetLevel + 6 * targetLevel;
        }
        if (targetLevel <= 31) {
            return (int)(2.5 * (double)targetLevel * (double)targetLevel - 40.5 * (double)targetLevel + 360.0);
        }
        return (int)(4.5 * (double)targetLevel * (double)targetLevel - 162.5 * (double)targetLevel + 2220.0);
    }

    public static int getTotalExperience(Player player) {
        int currentExperience = ExperienceUtils.getTotalExperience(player.experienceLevel);
        return (int)((float)currentExperience + player.experienceProgress * (float)ExperienceUtils.getExperienceForLevelAfter(player.experienceLevel));
    }
}

