/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import by.dragonsurvivalteam.dragonsurvival.util.TimedCooldown;

public class ActionWithTimedCooldown {
    private final TimedCooldown timedCooldown;
    private final Runnable action;

    public ActionWithTimedCooldown(long cooldownMs, Runnable action) {
        this.timedCooldown = new TimedCooldown(cooldownMs);
        this.action = action;
    }

    public long getCooldownMs() {
        return this.timedCooldown.getStartValue();
    }

    public Runnable getAction() {
        return this.action;
    }

    public boolean tryRun() {
        if (this.timedCooldown.isOnCooldown()) {
            return false;
        }
        this.forceRun();
        return true;
    }

    public void forceRun() {
        this.action.run();
        this.timedCooldown.forceSet();
    }

    public void resetCooldown() {
        this.timedCooldown.reset();
    }
}

