/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.tileentity;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.DragonBeaconData;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlockEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonBeaconBlockEntity
extends BlockEntity {
    private static final String DRAGON_BEACON_DATA = "dragon_beacon_data";
    private static final RandomSource RANDOM = RandomSource.create();
    public final float bobOffset = (float)((double)RANDOM.nextFloat() * Math.PI * 2.0);
    public float tick;
    @Nullable
    private DragonBeaconData data;

    public DragonBeaconBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)DSBlockEntities.DRAGON_BEACON.get(), position, state);
    }

    public int getExperienceCost() {
        if (this.data == null) {
            return 0;
        }
        return this.data.paymentData().experienceCost();
    }

    public boolean applyEffects(Player player, boolean paidExperience) {
        if (this.data == null) {
            return false;
        }
        if (this.data.effects().isEmpty()) {
            return false;
        }
        this.data.effects().forEach(effect -> {
            int duration = effect.duration();
            int amplifier = effect.amplifier();
            if (paidExperience) {
                duration *= this.data.paymentData().durationMultiplier();
                amplifier += this.data.paymentData().amplifierModification();
            }
            player.addEffect(new MobEffectInstance(effect.effect(), duration, amplifier, !paidExperience, true));
        });
        return true;
    }

    public void setData(@Nullable DragonBeaconData data) {
        this.data = data;
    }

    public static void serverTick(Level level, BlockPos position, BlockState state, DragonBeaconBlockEntity beacon) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            return;
        }
        if (beacon.data == null || level.getGameTime() % 20L != 0L) {
            return;
        }
        if (level.getBlockState(position.below()).getBlock() == DSBlocks.DRAGON_MEMORY_BLOCK.get()) {
            level.getEntitiesOfClass(Player.class, new AABB(position).inflate(50.0).expandTowards(0.0, (double)level.getMaxBuildHeight(), 0.0)).forEach(player -> beacon.applyEffects((Player)player, false));
        }
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        if (tag.contains(DRAGON_BEACON_DATA)) {
            DragonBeaconData.CODEC.decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound(DRAGON_BEACON_DATA)).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).ifPresent(data -> {
                this.data = (DragonBeaconData)data.getFirst();
            });
        }
    }

    public void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        if (this.data != null) {
            DragonBeaconData.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.data).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).ifPresent(compound -> tag.put(DRAGON_BEACON_DATA, compound));
        }
    }
}

