/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SpinDurationAndCooldown;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncFlyingPlayerAbility;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncWingsSpread;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncPlayerJump;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FlightData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SwimData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.PlayerFlyableFallEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class ServerFlightHandler {
    public static final int SPIN_DURATION = Functions.secondsToTicks(0.76);
    @ConfigRange(min=0.1, max=1.0)
    @Translation(key="flight_speed_multiplier", type=Translation.Type.CONFIGURATION, comments={"Flight speed multiplier"})
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="flight_speed_multiplier")
    public static Double maxFlightSpeed = 0.3;
    @ConfigRange(min=0.0, max=20.0)
    @Translation(key="flight_hunger_threshold", type=Translation.Type.CONFIGURATION, comments={"Determines the required food values to be able to fly"})
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="flight_hunger_threshold")
    public static Integer flightHungerThreshold = 6;
    @ConfigRange(min=0.0, max=20.0)
    @Translation(key="fold_wings_threshold", type=Translation.Type.CONFIGURATION, comments={"Determines the food values at which the dragon will stop being able to fly mid-flight"})
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="fold_wings_threshold")
    public static Integer foldWingsThreshold = 0;
    @Translation(key="fold_wings_on_land", type=Translation.Type.CONFIGURATION, comments={"If enabled dragons will automatically stop fold their wings (i.e. stop flying) when landing"})
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="fold_wings_on_land")
    public static Boolean foldWingsOnLand = false;
    @ConfigRange(min=0.0)
    @Translation(key="flight_spin_cooldown", type=Translation.Type.CONFIGURATION, comments={"Cooldown (in seconds) of the spin attack during flight"})
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="flight_spin_cooldown")
    public static Integer flightSpinCooldown = 5;
    @ConfigRange(min=1.0)
    @Translation(key="flight_hunger_ticks", type=Translation.Type.CONFIGURATION, comments={"Determines the amount of ticks (20 ticks = 1 second) it takes for one hunger point to be drained while flying"})
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="flight_hunger_ticks")
    public static int flightHungerTicks = 50;
    @Translation(key="stable_hover", type=Translation.Type.CONFIGURATION, comments={"If enabled hovering will behave the same as creative flight (i.e. stable flight)"})
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="stable_hover")
    public static boolean stableHover = false;
    @Translation(key="collision_damage_speed_factor", type=Translation.Type.CONFIGURATION, comments={"How much does the change in horizontal speed impact the damage taken from a collision whilst flying?"})
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="collision_damage_speed_factor")
    public static float collisionDamageSpeedFactor = 10.0f;
    @Translation(key="collision_damage_threshold", type=Translation.Type.CONFIGURATION, comments={"The amount of damage subtracted from the base damage when a collision occurs whilst flying."})
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="collision_damage_threshold")
    public static float collisionDamageThreshold = 3.0f;
    @Translation(key="enable_collision_damage", type=Translation.Type.CONFIGURATION, comments={"Dragons will take damage from colliding whilst glide-flying (similar to elytra)."})
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="enable_collision_damage")
    public static boolean enableCollisionDamage = true;
    @Translation(key="enable_flight_fall_damage", type=Translation.Type.CONFIGURATION, comments={"Dragons will take fall damage from colliding whilst glide-flying (similar to elytra)."})
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="enable_flight_fall_damage")
    public static boolean enableFlightFallDamage = true;
    @Translation(key="no_speed_requirement_for_vertical_acceleration", type=Translation.Type.CONFIGURATION, comments={"Dragons always accelerate vertically when flying, even when they aren't moving fast enough."})
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="no_speed_requirement_for_vertical_acceleration")
    public static Boolean noSpeedRequirementForVerticalAcceleration = false;

    @SubscribeEvent(receiveCanceled=true)
    public static void handleLanding(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ServerFlightHandler.handleLanding(player);
        }
    }

    @SubscribeEvent
    public static void handleLanding(PlayerFlyableFallEvent event) {
        Player player = event.getEntity();
        if (player instanceof Player) {
            Player player2 = player;
            ServerFlightHandler.handleLanding(player2);
        }
    }

    private static void handleLanding(Player player) {
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (!handler.isDragon()) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayersTrackingEntity((Entity)serverPlayer, (CustomPacketPayload)new SyncPlayerJump(player.getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            DragonEntity.DRAGONS_JUMPING.put(player.getId(), false);
        }
        if (!foldWingsOnLand.booleanValue() || player.level().isClientSide()) {
            return;
        }
        FlightData flightData = FlightData.getData(player);
        if (flightData.isWingsSpread()) {
            FlightData.getData((Player)player).areWingsSpread = false;
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncWingsSpread(player.getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void changeFallDistanceToUseFlightSpeed(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        double verticalFlightSpeed = livingEntity.getDeltaMovement().y * livingEntity.getDeltaMovement().y;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DragonStateProvider.getOptional((Entity)livingEntity).ifPresent(handler -> {
                FlightData data = FlightData.getData(player);
                if (handler.isDragon() && data.hasFlight() && data.isWingsSpread() && player.isSprinting() && !player.isPassenger()) {
                    if (!enableFlightFallDamage || verticalFlightSpeed <= 1.0 || livingEntity.isPassenger() && DragonStateProvider.isDragon(livingEntity.getVehicle())) {
                        event.setCanceled(true);
                        return;
                    }
                    double damage = verticalFlightSpeed * (handler.getGrowth() / 20.0);
                    damage = Mth.clamp((double)damage, (double)0.0, (double)(livingEntity.getHealth() - 1.0f));
                    float SAFE_FALL_DISTANCE_DEFAULT_VALUE = 3.0f;
                    event.setDistance((float)damage + 3.0f);
                }
            });
        }
    }

    public static boolean isFlying(Player player) {
        FlightData data = FlightData.getData(player);
        return data.hasFlight() && data.isWingsSpread() && !player.onGround() && !player.isInWater() && !player.isInLava() && !player.isPassenger();
    }

    @SubscribeEvent
    public static void handleEarlyFlightLogic(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (ServerFlightHandler.isGliding(player)) {
            handler.preCollisionDeltaMovement = player.getDeltaMovement();
        } else if (ServerFlightHandler.isFlying(player)) {
            player.resetFallDistance();
        }
        if (!player.level().isClientSide() && handler.isDragon()) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)player, (CustomPacketPayload)new SyncFlyingPlayerAbility(player.getId(), player.getAbilities().flying), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void handleWallCollisionsWhenFlying(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        if (player.horizontalCollision && ServerFlightHandler.isGliding(player) && enableCollisionDamage) {
            DragonStateHandler handler = DragonStateProvider.getData(player);
            double lostSpeed = handler.preCollisionDeltaMovement.horizontalDistance() - player.getDeltaMovement().horizontalDistance();
            float damage = (float)(lostSpeed * (double)collisionDamageSpeedFactor - (double)collisionDamageThreshold);
            if (damage > 0.0f) {
                player.playSound(player.getFallDamageSound((int)damage), 1.0f, 1.0f);
                player.hurt(player.damageSources().flyIntoWall(), damage);
                FlightData.getData((Player)player).areWingsSpread = false;
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncWingsSpread(player.getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void playerFlightAttacks(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (!handler.isDragon()) {
            return;
        }
        FlightData spin = FlightData.getData(player);
        if (!(player.level().isClientSide() || spin.duration <= 0 || ServerFlightHandler.isFlying(player) || ServerFlightHandler.canSwimSpin(player))) {
            spin.duration = 0;
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SpinDurationAndCooldown(player.getId(), spin.duration, spin.cooldown), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (ServerFlightHandler.isSpin(player)) {
            int range = 5;
            List entities = player.level().getEntities(null, new AABB(player.position().x - (double)range, player.position().y - (double)range, player.position().z - (double)range, player.position().x + (double)range, player.position().y + (double)range, player.position().z + (double)range));
            for (Entity target : entities) {
                LivingEntity entity;
                Player otherPlayer;
                if (target == player || target instanceof Player && !player.canHarmPlayer(otherPlayer = (Player)target) || target.distanceTo((Entity)player) > (float)range || player.hasPassenger(target) || target instanceof LivingEntity && (entity = (LivingEntity)target).getLastHurtByMob() == player && entity.getLastHurtByMobTimestamp() <= entity.tickCount + 100) continue;
                player.attack(target);
            }
            --spin.duration;
            if (!player.level().isClientSide()) {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SpinDurationAndCooldown(player.getId(), spin.duration, spin.cooldown), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else if (spin.cooldown > 0 && !player.level().isClientSide()) {
            --spin.cooldown;
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SpinDurationAndCooldown(player.getId(), spin.duration, spin.cooldown), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static boolean isSpin(Player entity) {
        FlightData spin = FlightData.getData(entity);
        if (ServerFlightHandler.isFlying(entity) || ServerFlightHandler.canSwimSpin(entity)) {
            return spin.duration > 0;
        }
        return false;
    }

    public static boolean canSwimSpin(Player player) {
        if (player.onGround()) {
            return false;
        }
        FlightData data = FlightData.getData(player);
        if (data.inFluid == null || !data.hasFlight()) {
            return false;
        }
        ResourceKey<FluidType> key = SwimData.key(player.getEyeInFluidType());
        if (key == null) {
            return false;
        }
        return data.inFluid.contains(player.registryAccess().holderOrThrow(key));
    }

    @SubscribeEvent
    public static void playerFoodExhaustion(PlayerTickEvent.Post playerTickEvent) {
        Player player = playerTickEvent.getEntity();
        DragonStateProvider.getOptional((Entity)player).ifPresent(dragonStateHandler -> {
            boolean wingsSpread;
            if (dragonStateHandler.isDragon() && (wingsSpread = FlightData.getData(player).isWingsSpread()) && ServerFlightHandler.isFlying(player)) {
                if (!player.level().isClientSide() && player.getFoodData().getFoodLevel() <= foldWingsThreshold && !player.isCreative()) {
                    player.sendSystemMessage((Component)Component.translatable((String)LangKey.MESSAGE_NO_HUNGER));
                    FlightData.getData((Player)player).areWingsSpread = false;
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncWingsSpread(player.getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return;
                }
                Vec3 delta = player.getDeltaMovement();
                float moveSpeed = (float)delta.horizontalDistance();
                float l = 4.0f / (float)flightHungerTicks;
                float moveSpeedReq = 1.0f;
                float minFoodReq = l / 10.0f;
                float drain = Math.max(minFoodReq, (float)(Math.min(1.0, (double)Math.max(0.0f, Math.max(moveSpeedReq - moveSpeed, 0.0f) / moveSpeedReq)) * (double)l));
                double flightStamina = player.getAttributeValue(DSAttributes.FLIGHT_STAMINA_COST);
                if (flightStamina > 0.0) {
                    drain /= (float)flightStamina;
                }
                player.causeFoodExhaustion(drain);
            }
        });
    }

    public static boolean isGliding(Player player) {
        boolean hasFood = player.getFoodData().getFoodLevel() > flightHungerThreshold || player.isCreative();
        return hasFood && player.isSprinting() && ServerFlightHandler.isFlying(player) && !player.hasEffect(MobEffects.LEVITATION);
    }

    public static double distanceFromGround(Player player) {
        BlockPos blockHeight = player.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, player.blockPosition());
        int height = blockHeight.getY();
        return Math.max(0.0, player.position().y - (double)height);
    }
}

