/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.animation.StopAbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.network.container.OpenDragonAltar;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncData;
import by.dragonsurvivalteam.dragonsurvival.network.sound.StopTickingSound;
import by.dragonsurvivalteam.dragonsurvival.network.syncing.SyncComplete;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.AltarData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.PenaltyTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.SupplyTrigger;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class PlayerLoginHandler {
    @SubscribeEvent
    public static void onTrackingStart(PlayerEvent.StartTracking event) {
        Player tracker = event.getEntity();
        Entity tracked = event.getTarget();
        PlayerLoginHandler.syncHandler(tracker, tracked);
    }

    @SubscribeEvent
    public static void onTrackingEnd(PlayerEvent.StopTracking event) {
        Player tracker = event.getEntity();
        Entity tracked = event.getTarget();
        PlayerLoginHandler.stopTickingSounds((Entity)tracker, tracked);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PlayerLoginHandler.stopTickingSoundsForAllPlayers(player);
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        DragonStateHandler handler = DragonStateProvider.getData((Player)player2);
        player2.getExistingData(DSDataAttachments.PENALTY_SUPPLY).ifPresent(data -> {
            if (!handler.isDragon()) {
                player2.removeData(DSDataAttachments.PENALTY_SUPPLY);
                return;
            }
            for (ResourceLocation supplyType : data.getSupplyTypes()) {
                if (!((DragonSpecies)handler.species().value()).penalties().stream().noneMatch(penalty -> {
                    SupplyTrigger supplyTrigger;
                    PenaltyTrigger patt0$temp = ((DragonPenalty)penalty.value()).trigger();
                    return patt0$temp instanceof SupplyTrigger && (supplyTrigger = (SupplyTrigger)patt0$temp).supplyType().equals((Object)supplyType);
                })) continue;
                data.remove(supplyType);
            }
        });
        if (ServerConfig.noHumansAllowed.booleanValue() && !handler.isDragon()) {
            handler.setSpecies((Player)player2, DragonSpecies.getRandom(player2));
            handler.setBody((Player)player2, DragonBody.getRandomUnlocked(player2));
            handler.setGrowth((Player)player2, ((DragonSpecies)handler.species().value()).getStartingGrowth((HolderLookup.Provider)player2.registryAccess()));
        }
        PlayerLoginHandler.syncComplete((Entity)player2);
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player2, (CustomPacketPayload)new StopAbilityAnimation(player2.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PlayerLoginHandler.syncComplete((Entity)player2);
        }
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerLoginHandler.syncComplete((Entity)event.getEntity());
    }

    @SubscribeEvent
    public static void startWithDragonChoice(PlayerTickEvent.Post event) {
        ServerPlayer serverPlayer;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer) || (serverPlayer = (ServerPlayer)player).isDeadOrDying()) {
            return;
        }
        AltarData data = AltarData.getData((Player)serverPlayer);
        if (data.altarCooldown > 0) {
            --data.altarCooldown;
        }
        if (!ServerConfig.startWithDragonChoice.booleanValue() || data.hasUsedAltar || data.isInAltar || serverPlayer.tickCount < Functions.secondsToTicks(5.0)) {
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenDragonAltar(DragonSpecies.getSpecies(serverPlayer, true)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        data.isInAltar = true;
    }

    private static void stopTickingSounds(Entity tracker, Entity tracked) {
        if (tracker instanceof ServerPlayer) {
            ServerPlayer trackedPlayer;
            MagicData magicDataTracked;
            DragonAbilityInstance currentlyCasting;
            ServerPlayer trackerPlayer = (ServerPlayer)tracker;
            if (tracked instanceof ServerPlayer && (currentlyCasting = (magicDataTracked = MagicData.getData((Player)(trackedPlayer = (ServerPlayer)tracked))).getCurrentlyCasting()) != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)trackerPlayer, (CustomPacketPayload)new StopTickingSound(currentlyCasting.location().withSuffix(trackedPlayer.getStringUUID())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private static void stopTickingSoundsForAllPlayers(ServerPlayer player) {
        MagicData magicData = MagicData.getData((Player)player);
        DragonAbilityInstance currentlyCasting = magicData.getCurrentlyCasting();
        if (currentlyCasting != null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new StopTickingSound(currentlyCasting.location().withSuffix(player.getStringUUID())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void syncHandler(ServerPlayer serverPlayer) {
        DragonStateHandler handler = DragonStateProvider.getData((Player)serverPlayer);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverPlayer, (CustomPacketPayload)new SyncComplete(serverPlayer.getId(), handler.serializeNBT((HolderLookup.Provider)serverPlayer.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        serverPlayer.getExistingData(DSDataAttachments.FLIGHT).ifPresent(data -> PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverPlayer, (CustomPacketPayload)new SyncData(serverPlayer.getId(), DSDataAttachments.FLIGHT.getId(), data.serializeNBT((HolderLookup.Provider)serverPlayer.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    public static void syncHandler(Player syncTo, Entity syncFrom) {
        if (syncTo instanceof ServerPlayer) {
            ServerPlayer target = (ServerPlayer)syncTo;
            if (syncFrom instanceof ServerPlayer) {
                ServerPlayer source = (ServerPlayer)syncFrom;
                DragonStateHandler handler = DragonStateProvider.getData((Player)source);
                PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)new SyncComplete(source.getId(), handler.serializeNBT((HolderLookup.Provider)source.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                syncFrom.getExistingData(DSDataAttachments.FLIGHT).ifPresent(data -> data.sync(source, target));
            }
        }
    }

    public static void syncComplete(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            DragonStateProvider.getOptional((Entity)player).ifPresent(handler -> {
                SyncComplete.handleDragonSync(player, true);
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncComplete(player.getId(), handler.serializeNBT((HolderLookup.Provider)player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            });
            PlayerLoginHandler.syncDataAttachments(player);
        }
    }

    private static void syncDataAttachments(ServerPlayer player) {
        player.getExistingData(DSDataAttachments.PENALTY_SUPPLY).ifPresent(data -> data.sync(player));
        player.getExistingData(DSDataAttachments.ALTAR).ifPresent(data -> data.sync(player));
        player.getExistingData(DSDataAttachments.CLAW_INVENTORY).ifPresent(data -> data.sync((Player)player));
        player.getExistingData(DSDataAttachments.FLIGHT).ifPresent(data -> data.sync(player));
        player.getExistingData(DSDataAttachments.SWIM).ifPresent(data -> data.sync(player));
        DSDataAttachments.getStorages((Entity)player).forEach(storage -> storage.sync(player));
    }
}

