/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.OffsetConfig;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncDragonPassengerID;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class DragonRidingHandler {
    @Translation(key="riding_offsets", type=Translation.Type.CONFIGURATION, comments={"Offset the riding position per entity type", "Format: resource/tag;x_offset;y_offset;z_offset", "The resource can also be defined using regular expressions (for both namespace and path)"})
    @ConfigOption(side=ConfigSide.SERVER, category={"riding"}, key="riding_offsets")
    public static List<OffsetConfig> OFFSETS = List.of(OffsetConfig.create(Tags.EntityTypes.BOATS, new Vec3(0.0, 0.9, 0.0)));
    @Translation(comments={"You are too big to mount on this creature. You must be at most %s the scale of the creature you are trying to ride or smaller, but you are scale %s and the creature is scale %s."})
    private static final String SELF_TOO_BIG = Translation.Type.GUI.wrap("message.self_too_big");
    @Translation(comments={"The creature you are trying to ride must be crouching for you to mount them."})
    private static final String NOT_CROUCHING = Translation.Type.GUI.wrap("message.not_crouching");
    public static final int NO_PASSENGER = -1;
    public static final Vec3 BASE_MOUNTING_OFFSET = new Vec3(0.0, 0.63, 0.0);
    public static final float PLAYER_RIDING_SCALE_RATIO = 0.8f;
    public static final float DRAGON_RIDING_SCALE_RATIO = 0.5f;

    public static Vec3 getMountingOffsetForEntity(Entity entity) {
        for (OffsetConfig config : OFFSETS) {
            Vec3 offset = config.getOffset(entity.getType().builtInRegistryHolder().key());
            if (offset == null) continue;
            return offset;
        }
        return BASE_MOUNTING_OFFSET;
    }

    private static DragonRideAttemptResult playerCanRideDragon(Player rider, Player mount) {
        boolean dragonIsTooSmallToRide;
        if (rider.isSpectator() || mount.isSpectator() || rider.isSleeping() || mount.isSleeping()) {
            return DragonRideAttemptResult.OTHER;
        }
        DragonStateHandler mountData = DragonStateProvider.getData(mount);
        if (!mountData.isDragon() || ((DragonBody)mountData.body().value()).mountingOffsets().isEmpty()) {
            return DragonRideAttemptResult.OTHER;
        }
        double scaleRatio = rider.getScale() / mount.getScale();
        boolean bl = DragonStateProvider.isDragon((Entity)rider) ? scaleRatio >= 0.5 : (dragonIsTooSmallToRide = scaleRatio >= (double)0.8f);
        if (dragonIsTooSmallToRide) {
            return DragonRideAttemptResult.SELF_TOO_BIG;
        }
        if (mount.getPose() != Pose.CROUCHING) {
            return DragonRideAttemptResult.NOT_CROUCHING;
        }
        return DragonRideAttemptResult.SUCCESS;
    }

    @SubscribeEvent
    public static void onRideAttempt(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer target = (ServerPlayer)entity;
        if (event.getHand() != InteractionHand.MAIN_HAND || !event.getItemStack().isEmpty()) {
            return;
        }
        Player self = event.getEntity();
        DragonRideAttemptResult result = DragonRidingHandler.playerCanRideDragon(self, (Player)target);
        if (result == DragonRideAttemptResult.SUCCESS && !target.isVehicle()) {
            self.startRiding((Entity)target);
            target.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)target));
            DragonStateProvider.getData((Player)target).setPassengerId(self.getId());
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)target, (CustomPacketPayload)new SyncDragonPassengerID(target.getId(), self.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        } else if (result == DragonRideAttemptResult.SELF_TOO_BIG) {
            float ridingScaleRatio = DragonStateProvider.isDragon((Entity)self) ? 0.5f : 0.8f;
            self.sendSystemMessage((Component)Component.translatable((String)SELF_TOO_BIG, (Object[])new Object[]{NumberFormat.getPercentInstance().format(ridingScaleRatio), String.format("%.2f", Float.valueOf(self.getScale())), String.format("%.2f", Float.valueOf(target.getScale()))}));
        } else if (result == DragonRideAttemptResult.NOT_CROUCHING) {
            self.sendSystemMessage((Component)Component.translatable((String)NOT_CROUCHING));
        }
    }

    @SubscribeEvent
    public static void updateRidingState(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DragonStateProvider.getOptional((Entity)player2).ifPresent(dragonStateHandler -> {
                int passengerId = dragonStateHandler.getPassengerId();
                if (passengerId == -1) {
                    return;
                }
                Entity passenger = player2.level().getEntity(passengerId);
                if (passenger == null || !player2.hasPassenger(passenger) || passenger.getRootVehicle() != player2.getRootVehicle() || !player2.isVehicle()) {
                    dragonStateHandler.setPassengerId(-1);
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player2, (CustomPacketPayload)new SyncDragonPassengerID(player2.getId(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    if (passenger != null) {
                        passenger.stopRiding();
                    }
                    player.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)player2));
                    return;
                }
                if (passenger instanceof Player) {
                    Player playerPassenger = (Player)passenger;
                    DragonRideAttemptResult result = DragonRidingHandler.playerCanRideDragon(playerPassenger, (Player)player2);
                    if (result == DragonRideAttemptResult.SUCCESS || result == DragonRideAttemptResult.NOT_CROUCHING) {
                        return;
                    }
                    dragonStateHandler.setPassengerId(-1);
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player2, (CustomPacketPayload)new SyncDragonPassengerID(player2.getId(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    passenger.stopRiding();
                    player.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)player2));
                }
            });
        }
    }

    @SubscribeEvent
    public static void dismountOnPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player2 = (player = (ServerPlayer)player2).getVehicle()) instanceof ServerPlayer) {
            ServerPlayer vehicle = (ServerPlayer)player2;
            DragonStateProvider.getOptional((Entity)vehicle).ifPresent(handler -> {
                player.stopRiding();
                vehicle.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)vehicle));
                handler.setPassengerId(-1);
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)vehicle, (CustomPacketPayload)new SyncDragonPassengerID(vehicle.getId(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            });
        }
    }

    private static enum DragonRideAttemptResult {
        SELF_TOO_BIG,
        NOT_CROUCHING,
        OTHER,
        SUCCESS;

    }
}

