/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects.ProjectileEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.LightningHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.projectile.Projectile;

public record ProjectileLightningEntityEffect(LightningHandler.Data data) implements ProjectileEntityEffect
{
    public static final MapCodec<ProjectileLightningEntityEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LightningHandler.Data.CODEC.fieldOf("data").forGetter(ProjectileLightningEntityEffect::data)).apply((Applicative)instance, ProjectileLightningEntityEffect::new));

    @Override
    public void apply(Projectile projectile, Entity target, int level) {
        LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(projectile.level());
        bolt.moveTo(target.position());
        Entity entity = projectile.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            bolt.setCause(serverPlayer);
        }
        bolt.setData(DSDataAttachments.LIGHTNING_BOLT, (Object)LightningHandler.fromData(this.data));
        projectile.level().addFreshEntity((Entity)bolt);
    }

    @Override
    public MapCodec<? extends ProjectileEntityEffect> codec() {
        return CODEC;
    }
}

