/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.TargetDirection;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects.ProjectileEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.phys.Vec3;

public record ProjectileEntityPushEffect(TargetDirection targetDirection, LevelBasedValue pushForce) implements ProjectileEntityEffect
{
    @Translation(comments={"Pulls targets towards the projectile with a strength of %s."})
    public static final String TOWARDS = Translation.Type.GUI.wrap("projectile_push_effect.towards");
    @Translation(comments={"Pushes targets away from the projectile with a strength of %s."})
    public static final String AWAY = Translation.Type.GUI.wrap("projectile_push_effect.away");
    @Translation(comments={"Pushes targets in the direction the projectile is travelling with a strength of %s"})
    public static final String FACING = Translation.Type.GUI.wrap("projectile_push_effect.facing");
    @Translation(comments={"Pushes targets %s with a strength of %s."})
    public static final String DIRECTIONAL = Translation.Type.GUI.wrap("projectile_push_effect.directional");
    public static final MapCodec<ProjectileEntityPushEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TargetDirection.CODEC.fieldOf("target_direction").forGetter(ProjectileEntityPushEffect::targetDirection), (App)LevelBasedValue.CODEC.fieldOf("push_force").forGetter(ProjectileEntityPushEffect::pushForce)).apply((Applicative)instance, ProjectileEntityPushEffect::new));

    @Override
    public void apply(Projectile projectile, Entity target, int level) {
        if (projectile.level() instanceof ServerLevel) {
            if (this.targetDirection.direction().left().orElse(null) == TargetDirection.Type.LOOKING_AT) {
                target.addDeltaMovement(projectile.getLookAngle().scale((double)this.pushForce.calculate(level)));
            } else if (this.targetDirection.direction().left().orElse(null) == TargetDirection.Type.TOWARDS_ENTITY) {
                Vec3 offset = new Vec3(projectile.position().x, projectile.position().y, projectile.position().z()).subtract(target.position()).normalize();
                target.addDeltaMovement(offset.scale((double)this.pushForce.calculate(level)));
            } else if (this.targetDirection.direction().right().isPresent()) {
                target.addDeltaMovement(new Vec3(((Direction)this.targetDirection.direction().right().get()).step()).normalize().scale((double)this.pushForce.calculate(level)));
            }
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, int level) {
        if (this.targetDirection.direction().left().orElse(null) == TargetDirection.Type.LOOKING_AT) {
            return List.of(Component.translatable((String)FACING, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.pushForce.calculate(level)))}));
        }
        if (this.targetDirection.direction().left().orElse(null) == TargetDirection.Type.TOWARDS_ENTITY) {
            if (this.pushForce.calculate(level) > 0.0f) {
                return List.of(Component.translatable((String)TOWARDS, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.pushForce.calculate(level)))}));
            }
            if (this.pushForce.calculate(level) < 0.0f) {
                return List.of(Component.translatable((String)AWAY, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.pushForce.calculate(level)))}));
            }
        } else if (this.targetDirection.direction().right().isPresent()) {
            return List.of(Component.translatable((String)DIRECTIONAL, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.pushForce.calculate(level)))}));
        }
        return List.of();
    }

    @Override
    public MapCodec<? extends ProjectileEntityEffect> codec() {
        return CODEC;
    }
}

