/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Fear;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.PotionData;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstanceBase;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates.EntityCheckPredicate;
import by.dragonsurvivalteam.dragonsurvival.common.conditions.EntityCondition;
import by.dragonsurvivalteam.dragonsurvival.common.conditions.ItemCondition;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSBlockTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSEntityTypeTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSItemTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DamagePenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.FearPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.HitByProjectileTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.HitByWaterPotionTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.InstantTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.ItemBlacklistPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.ItemUsedTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.MobEffectPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.PenaltyTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.SupplyTrigger;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.Tags;

public class DragonPenalties {
    @Translation.Translations(value={@Translation(type=Translation.Type.PENALTY_DESCRIPTION, comments={"\u25a0 Cave dragons slowly take \u00a7cdamage\u00a7r while in snow or rain due to their fiery nature.\n", "\u25a0 The skill \u00a72\u00abContrast Shower\u00bb\u00a7r \u00a77could make your life easier.\n"}), @Translation(type=Translation.Type.PENALTY, comments={"Cold Weakness"})})
    public static final ResourceKey<DragonPenalty> COLD_WEAKNESS = DragonPenalties.key("cold_weakness");
    @Translation.Translations(value={@Translation(type=Translation.Type.PENALTY_DESCRIPTION, comments={"\u25a0 Cave dragons quickly take \u00a7cdamage\u00a7r from water. Explosive water potions and snowballs also deal damage.\n", "\u25a0 The effect \u00a72\u00abCave Fire\u00bb\u00a7r \u00a77could make your life easier.\n"}), @Translation(type=Translation.Type.PENALTY, comments={"Water Weakness"})})
    public static final ResourceKey<DragonPenalty> WATER_WEAKNESS = DragonPenalties.key("water_weakness");
    @Translation.Translations(value={@Translation(type=Translation.Type.PENALTY_DESCRIPTION, comments={"\u25a0 If sea dragon are outside of the water for too long, they will \u00a7ddehydrate\u00a7r\u00a77 and suffer \u00a7ddamage\u00a7r\u00a77.\n", "\u25a0 Being in rain, ice or snow or drinking water bottles rehydrates you. The skill \u00a72\u00abHydration Capacity\u00bb\u00a7r \u00a77could make your life easier.\n"}), @Translation(type=Translation.Type.PENALTY, comments={"Thin Skin"})})
    public static final ResourceKey<DragonPenalty> THIN_SKIN = DragonPenalties.key("thin_skin");
    @Translation.Translations(value={@Translation(type=Translation.Type.PENALTY_DESCRIPTION, comments={"\u25a0 Dragons are \u00a7dunable to wield\u00a7r\u00a77 or equip certain items. Such as bows, shields, and tridents. They won't equip and will \u00a7cdrop\u00a7r from the hotbar, but you can still craft items with it."}), @Translation(type=Translation.Type.PENALTY, comments={"Item Blacklist"})})
    public static final ResourceKey<DragonPenalty> ITEM_BLACKLIST = DragonPenalties.key("item_blacklist");
    @Translation.Translations(value={@Translation(type=Translation.Type.PENALTY_DESCRIPTION, comments={"\u25a0 The predatory plants in your body dislike \u00a7dDarkness\u00a7r. If the light level around you is lower than 4, you may receive the \u00a7c\u00abStress\u00bb\u00a7r effect, rapidly draining your food gauge.\n", "\u25a0 The skill \u00a72\u00abLight the Dark\u00bb \u00a77and effect \u00a72\u00abForest Magic\u00bb \u00a77could make your life easier."}), @Translation(type=Translation.Type.PENALTY, comments={"Fear of Darkness"})})
    public static final ResourceKey<DragonPenalty> FEAR_OF_DARKNESS = DragonPenalties.key("fear_of_darkness");
    public static final ResourceKey<DragonPenalty> WATER_POTION_WEAKNESS = DragonPenalties.key("water_potion_weakness");
    public static final ResourceKey<DragonPenalty> WATER_SPLASH_POTION_WEAKNESS = DragonPenalties.key("water_splash_potion_weakness");
    public static final ResourceKey<DragonPenalty> SNOWBALL_WEAKNESS = DragonPenalties.key("snowball_weakness");
    @Translation.Translations(value={@Translation(type=Translation.Type.PENALTY_DESCRIPTION, comments={"\u25a0 Dragons are \u00a7dscary\u00a7r\u00a77  creatures. Animals will try to \u00a7cavoid\u00a7r them.\n", "\u25a0 Build the \u00a72\u00abBeacon\u00bb\u00a77 to become more attractive."}), @Translation(type=Translation.Type.PENALTY, comments={"Fear"})})
    public static final ResourceKey<DragonPenalty> FEAR = DragonPenalties.key("fear");
    public static final List<String> DEFAULT_COMMON_BLACKLIST = List.of("#" + String.valueOf(Tags.Items.TOOLS_SHIELD.location()), "#" + String.valueOf(Tags.Items.TOOLS_BOW.location()), "#" + String.valueOf(Tags.Items.TOOLS_CROSSBOW.location()), "minecraft:trident", "born_in_chaos_v1:staffof_magic_arrows", "mowziesmobs:wrought_axe", "revised_phantoms:phantom_wings_chestplate", "quark:flamerang", "quark:pickarang", ".*:.*?elytra.*");

    public static void registerPenalties(BootstrapContext<DragonPenalty> context) {
        context.register(COLD_WEAKNESS, (Object)new DragonPenalty(Optional.of(DragonSurvival.res("penalties/cave/cold_weakness")), Optional.of(AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{Condition.thisEntity(EntityCondition.isInRainOrSnow()), Condition.thisEntity(EntityCondition.isOnBlock(DSBlockTags.IS_WET)), Condition.thisEntity(EntityCondition.isInBlock(DSBlockTags.IS_WET))}).and(Condition.thisEntity(EntityCondition.hasEffect(DSEffects.FIRE)).invert()).build()), new DamagePenalty((Holder<DamageType>)context.lookup(Registries.DAMAGE_TYPE).getOrThrow(DSDamageTypes.RAIN_BURN), 1.0f), new SupplyTrigger(DragonSurvival.res("rain_supply"), DSAttributes.PENALTY_RESISTANCE_TIME, Functions.secondsToTicks(2.0), 1.0f, 0.013f, List.of(), false, Optional.of(ParticleTypes.SMOKE))));
        context.register(WATER_WEAKNESS, (Object)new DragonPenalty(Optional.of(DragonSurvival.res("penalties/cave/water_weakness")), Optional.of(Condition.thisEntity(EntityCondition.isInFluid((HolderSet<Fluid>)context.lookup(Registries.FLUID).getOrThrow(FluidTags.WATER))).and(Condition.thisEntity(EntityCondition.hasEffect(DSEffects.FIRE)).invert()).build()), new DamagePenalty((Holder<DamageType>)context.lookup(Registries.DAMAGE_TYPE).getOrThrow(DSDamageTypes.WATER_BURN), 1.0f), new InstantTrigger(10)));
        context.register(THIN_SKIN, (Object)new DragonPenalty(Optional.of(DragonSurvival.res("penalties/sea/thin_skin")), Optional.of(AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{Condition.thisEntity(EntityCondition.hasEffect(DSEffects.PEACE)), Condition.thisEntity(EntityCondition.isInFluid((HolderSet<Fluid>)context.lookup(Registries.FLUID).getOrThrow(FluidTags.WATER))), Condition.thisEntity(EntityCondition.isOnBlock(DSBlockTags.IS_WET)), Condition.thisEntity(EntityCondition.isInBlock(DSBlockTags.IS_WET)), Condition.thisEntity(EntityCondition.isInRainOrSnow())}).invert().build()), new DamagePenalty((Holder<DamageType>)context.lookup(Registries.DAMAGE_TYPE).getOrThrow(DSDamageTypes.DEHYDRATION), 1.0f), new SupplyTrigger(DragonSurvival.res("water_supply"), DSAttributes.PENALTY_RESISTANCE_TIME, Functions.secondsToTicks(2.0), 1.0f, 0.013f, List.of(new SupplyTrigger.RecoveryItem(List.of(ItemCondition.is((ItemLike)DSItems.FROZEN_RAW_FISH.value()), ItemCondition.hasPotion(Potions.WATER)), 0.5f)), true, Optional.empty())));
        context.register(ITEM_BLACKLIST, (Object)new DragonPenalty(Optional.of(DragonSurvival.res("penalties/general/item_blacklist")), Optional.empty(), new ItemBlacklistPenalty(DEFAULT_COMMON_BLACKLIST), PenaltyTrigger.instant()));
        context.register(FEAR_OF_DARKNESS, (Object)new DragonPenalty(Optional.of(DragonSurvival.res("penalties/forest/fear_of_darkness")), Optional.of(AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{Condition.thisEntity(EntityCondition.hasEffect(DSEffects.MAGIC)), Condition.thisEntity(EntityCondition.hasEffect(MobEffects.GLOWING)), Condition.thisEntity(EntityCondition.isItemEquipped(EquipmentSlot.MAINHAND, DSItemTags.LIGHT_SOURCE)), Condition.thisEntity(EntityCondition.isItemEquipped(EquipmentSlot.OFFHAND, DSItemTags.LIGHT_SOURCE)), Condition.thisEntity(EntityCondition.isInLight(3))}).invert().build()), new MobEffectPenalty(PotionData.create(DSEffects.STRESS).duration(10).showParticles().build()), new SupplyTrigger(DragonSurvival.res("stress_supply"), DSAttributes.PENALTY_RESISTANCE_TIME, Functions.secondsToTicks(2.0), 1.0f, 0.013f, List.of(), false, Optional.empty())));
        context.register(WATER_POTION_WEAKNESS, (Object)new DragonPenalty(Optional.empty(), Optional.empty(), new DamagePenalty((Holder<DamageType>)context.lookup(Registries.DAMAGE_TYPE).getOrThrow(DSDamageTypes.WATER_BURN), 2.0f), new ItemUsedTrigger(List.of(ItemCondition.hasPotion(Potions.WATER), ItemCondition.is(new ItemLike[]{Items.MILK_BUCKET})))));
        context.register(WATER_SPLASH_POTION_WEAKNESS, (Object)new DragonPenalty(Optional.empty(), Optional.empty(), new DamagePenalty((Holder<DamageType>)context.lookup(Registries.DAMAGE_TYPE).getOrThrow(DSDamageTypes.WATER_BURN), 2.0f), HitByWaterPotionTrigger.INSTANCE));
        context.register(SNOWBALL_WEAKNESS, (Object)new DragonPenalty(Optional.empty(), Optional.empty(), new DamagePenalty((Holder<DamageType>)context.lookup(Registries.DAMAGE_TYPE).getOrThrow(DSDamageTypes.WATER_BURN), 2.0f), new HitByProjectileTrigger((HolderSet<EntityType<?>>)HolderSet.direct((Holder[])new Holder[]{EntityType.SNOWBALL.builtInRegistryHolder()}))));
        context.register(FEAR, (Object)new DragonPenalty(Optional.of(DragonSurvival.res("penalties/general/fear")), Optional.of(Condition.thisEntity(EntityCondition.hasEffect(DSEffects.ANIMAL_PEACE)).invert().build()), new FearPenalty(List.of(new Fear(DurationInstanceBase.create(DragonSurvival.res("animals")).infinite().removeAutomatically().hidden().build(), Optional.of(Condition.thisEntity(EntityCondition.isType(EntityCheckPredicate.Type.ANIMAL)).and(Condition.thisEntity(EntityCondition.isType(DSEntityTypeTags.ANIMAL_AVOID_BLACKLIST)).invert()).build()), (LevelBasedValue)LevelBasedValue.constant((float)20.0f), (LevelBasedValue)LevelBasedValue.constant((float)1.3f), (LevelBasedValue)LevelBasedValue.constant((float)1.5f)))), PenaltyTrigger.instant()));
    }

    public static ResourceKey<DragonPenalty> key(ResourceLocation location) {
        return ResourceKey.create(DragonPenalty.REGISTRY, (ResourceLocation)location);
    }

    public static ResourceKey<DragonPenalty> key(String path) {
        return DragonPenalties.key(DragonSurvival.res(path));
    }
}

