/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade;

import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.UpgradeType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public record ItemUpgrade(List<HolderSet<Item>> upgradeItems, HolderSet<Item> downgradeItems) implements UpgradeType<Item>
{
    public static final MapCodec<ItemUpgrade> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM).listOf().fieldOf("items_per_level").forGetter(ItemUpgrade::upgradeItems), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM).fieldOf("downgrade_items").forGetter(ItemUpgrade::downgradeItems)).apply((Applicative)instance, ItemUpgrade::new));

    @Override
    public boolean apply(ServerPlayer dragon, DragonAbilityInstance ability, Item input) {
        if (this.handleAutoUpgrade(ability, input)) {
            return true;
        }
        if (ability.level() > 0 && this.downgradeItems.contains((Holder)input.builtInRegistryHolder())) {
            ability.setLevel(ability.level() - 1);
            return true;
        }
        if (ability.level() >= this.upgradeItems.size()) {
            return false;
        }
        if (this.upgradeItems.get(ability.level()).contains((Holder)input.builtInRegistryHolder())) {
            ability.setLevel(ability.level() + 1);
            return true;
        }
        return false;
    }

    private boolean handleAutoUpgrade(DragonAbilityInstance ability, Item input) {
        if (input != Items.AIR) {
            return false;
        }
        if (ability.level() >= this.upgradeItems.size()) {
            return false;
        }
        if (this.upgradeItems.get(ability.level()).size() == 0) {
            ability.setLevel(ability.level() + 1);
            return true;
        }
        return false;
    }

    @Override
    public MutableComponent getDescription(int abilityLevel) {
        return Component.empty();
    }

    @Override
    public int maxLevel() {
        return this.upgradeItems.size();
    }

    @Override
    public MapCodec<? extends UpgradeType<?>> codec() {
        return CODEC;
    }
}

