/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.AbilityTargeting;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public record LookingAtTarget(Either<AbilityTargeting.BlockTargeting, AbilityTargeting.EntityTargeting> target, LevelBasedValue range) implements AbilityTargeting
{
    @Translation(comments={"Targets a block that you are looking at within a range of %s blocks"})
    private static final String LOOKING_AT_TARGET_BLOCK = Translation.Type.GUI.wrap("ability_target.looking_at.block");
    @Translation(comments={"Targets %s that you are looking at within a range of %s blocks"})
    private static final String LOOKING_AT_TARGET_ENTITY = Translation.Type.GUI.wrap("ability_target.looking_at.entity");
    public static final MapCodec<LookingAtTarget> CODEC = RecordCodecBuilder.mapCodec(instance -> AbilityTargeting.codecStart(instance).and((App)LevelBasedValue.CODEC.fieldOf("range").forGetter(LookingAtTarget::range)).apply((Applicative)instance, LookingAtTarget::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability) {
        this.target().ifLeft(blockTarget -> {
            HitResult result = this.getBlockHitResult((Player)dragon, ability);
            if (result.getType() == HitResult.Type.MISS || !(result instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult blockHitResult = (BlockHitResult)result;
            if (!blockTarget.matches(dragon, blockHitResult.getBlockPos()) || !dragon.serverLevel().isLoaded(blockHitResult.getBlockPos())) {
                return;
            }
            blockTarget.effects().forEach(target -> target.apply(dragon, ability, blockHitResult.getBlockPos(), blockHitResult.getDirection()));
        }).ifRight(entityTarget -> {
            Predicate<Entity> filter = entity -> entityTarget.targetingMode().isEntityRelevant((Player)dragon, (Entity)entity) && entityTarget.matches(dragon, (Entity)entity, entity.position());
            HitResult result = this.getEntityHitResult((Player)dragon, filter, ability);
            if (result.getType() == HitResult.Type.MISS || !(result instanceof EntityHitResult)) {
                return;
            }
            EntityHitResult entityHitResult = (EntityHitResult)result;
            entityTarget.effects().forEach(target -> target.apply(dragon, ability, entityHitResult.getEntity()));
        });
    }

    @Override
    public MutableComponent getDescription(Player dragon, DragonAbilityInstance ability) {
        Component targetingComponent = (Component)this.target.map(block -> null, entity -> entity.targetingMode().translation());
        MutableComponent range = DSColors.dynamicValue(FORMAT.format(this.range.calculate(ability.level())));
        if (targetingComponent == null) {
            return Component.translatable((String)LOOKING_AT_TARGET_BLOCK, (Object[])new Object[]{range});
        }
        return Component.translatable((String)LOOKING_AT_TARGET_ENTITY, (Object[])new Object[]{DSColors.dynamicValue(targetingComponent), range});
    }

    public HitResult getBlockHitResult(Player dragon, DragonAbilityInstance ability) {
        return dragon.pick((double)this.range.calculate(ability.level()), 0.0f, false);
    }

    public HitResult getEntityHitResult(Player dragon, Predicate<Entity> filter, DragonAbilityInstance ability) {
        return ProjectileUtil.getHitResultOnViewVector((Entity)dragon, filter, (double)this.range.calculate(ability.level()));
    }

    @Override
    public MapCodec<? extends AbilityTargeting> codec() {
        return CODEC;
    }
}

