/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncSpinStatus;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FlightData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public record SpinEffect(int levelRequirement, Optional<HolderSet<FluidType>> fluidTypes) implements AbilityEntityEffect
{
    @Translation(comments={"\u00a76\u25a0 Can use spin"})
    private static final String SPIN = Translation.Type.GUI.wrap("spin_effect.spin");
    public static final MapCodec<SpinEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("level_requirement").forGetter(SpinEffect::levelRequirement), (App)RegistryCodecs.homogeneousList((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES).optionalFieldOf("fluid_types").forGetter(SpinEffect::fluidTypes)).apply((Applicative)instance, SpinEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        ServerPlayer serverTarget;
        if (!(target instanceof ServerPlayer) || !DragonStateProvider.isDragon((Entity)(serverTarget = (ServerPlayer)target))) {
            return;
        }
        FlightData data = FlightData.getData((Player)serverTarget);
        boolean hadSpin = data.hasSpin;
        if (ability.level() >= this.levelRequirement) {
            data.hasSpin = true;
            data.inFluid = this.fluidTypes.orElse(null);
        } else {
            data.hasSpin = false;
        }
        if (hadSpin != data.hasSpin) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverTarget, (CustomPacketPayload)new SyncSpinStatus(serverTarget.getId(), data.hasSpin, Optional.ofNullable(data.inFluid)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void remove(ServerPlayer dragon, DragonAbilityInstance ability, Entity target, boolean isAutoRemoval) {
        ServerPlayer serverTarget;
        if (isAutoRemoval) {
            return;
        }
        if (!(target instanceof ServerPlayer) || !DragonStateProvider.isDragon((Entity)(serverTarget = (ServerPlayer)target))) {
            return;
        }
        FlightData data = FlightData.getData((Player)serverTarget);
        boolean hadSpin = data.hasSpin;
        data.hasSpin = false;
        if (hadSpin != data.hasSpin) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverTarget, (CustomPacketPayload)new SyncSpinStatus(serverTarget.getId(), data.hasSpin, Optional.ofNullable(data.inFluid)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        if (ability.level() >= this.levelRequirement) {
            components.add(Component.translatable((String)SPIN));
        }
        return components;
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

