/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.TargetDirection;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.phys.Vec3;

public record PushEffect(TargetDirection targetDirection, LevelBasedValue pushForce) implements AbilityEntityEffect
{
    @Translation(comments={"Pulls targets towards you with a strength of %s."})
    public static final String TOWARDS = Translation.Type.GUI.wrap("push_effect.towards");
    @Translation(comments={"Pushes targets away from you with a strength of %s."})
    public static final String AWAY = Translation.Type.GUI.wrap("push_effect.away");
    @Translation(comments={"Pushes targets in the direction you are facing with a strength of %s"})
    public static final String FACING = Translation.Type.GUI.wrap("push_effect.facing");
    @Translation(comments={"Pushes targets %s with a strength of %s."})
    public static final String DIRECTIONAL = Translation.Type.GUI.wrap("push_effect.directional");
    public static final MapCodec<PushEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TargetDirection.CODEC.fieldOf("target_direction").forGetter(PushEffect::targetDirection), (App)LevelBasedValue.CODEC.fieldOf("push_force").forGetter(PushEffect::pushForce)).apply((Applicative)instance, PushEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        if (this.targetDirection.direction().left().orElse(null) == TargetDirection.Type.LOOKING_AT) {
            target.addDeltaMovement(dragon.getLookAngle().scale((double)this.pushForce.calculate(ability.level())));
        } else if (this.targetDirection.direction().left().orElse(null) == TargetDirection.Type.TOWARDS_ENTITY) {
            Vec3 offset = dragon.getEyePosition().subtract(target.getEyePosition()).normalize();
            target.addDeltaMovement(offset.scale((double)this.pushForce.calculate(ability.level())));
        } else if (this.targetDirection.direction().right().isPresent()) {
            target.addDeltaMovement(new Vec3(((Direction)this.targetDirection.direction().right().get()).step()).normalize().scale((double)this.pushForce.calculate(ability.level())));
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        if (this.targetDirection.direction().left().orElse(null) == TargetDirection.Type.LOOKING_AT) {
            return List.of(Component.translatable((String)FACING, (Object[])new Object[]{this.targetDirection, DSColors.dynamicValue(Float.valueOf(this.pushForce.calculate(ability.level())))}));
        }
        if (this.targetDirection.direction().left().orElse(null) == TargetDirection.Type.TOWARDS_ENTITY) {
            if (this.pushForce.calculate(ability.level()) > 0.0f) {
                return List.of(Component.translatable((String)TOWARDS, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.pushForce.calculate(ability.level())))}));
            }
            if (this.pushForce.calculate(ability.level()) < 0.0f) {
                return List.of(Component.translatable((String)AWAY, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.pushForce.calculate(ability.level())))}));
            }
        } else if (this.targetDirection.direction().right().isPresent()) {
            return List.of(Component.translatable((String)DIRECTIONAL, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.pushForce.calculate(ability.level())))}));
        }
        return List.of();
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

